<?php

namespace App\Livewire;

use Livewire\Component;

use App\Models\Button;
use App\Models\Event;
use App\Models\User;
use App\Models\SubCard;
use App\Models\UserSettings;
use App\Settings\CardDefaultsSetting;
use App\Models\Ad;
use App\Models\Product;

class EventInfoPage extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $ad_banner_w;
    public $ad_banner_h;
    public $app_name;

    public $card_title;
    public $page_title;
    public $event_title;
    public $username;
    public $slug;
    public $user;
    public $fullname;
    public $favicon;
    public $event;
    public array $videos = [''];
    public $video_count;
    public $directions;

    public $showFooter;
    //profile layout
    public $profile_layout;

    //footer by user
    public ?string $footer_text;
    public ?string $footer_link;

    //footer by user
    public ?string $default_footer_text;
    public ?string $default_footer_link;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    //Ads
    public $ads_top, $ads_bottom;
    public $getAds = false;

    public $user_id;

    public $color_settings_profile_pic_border;
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;
    public $color_settings_link;

    //style
    public $button_style;

    public $is_active;

    public $condition;

    public $contacts;
    public $products;
    public array $contact_settings = [];
    public $username_enabled;
    public $short_bio_enabled;
    public $display_country;

    public function displayEvent($username, $slug)
    {
        // get user creds
        $this->username = $username;
        $this->slug = $slug;

        if ($this->mainCard == true) {
            $this->user = User::where('username', $this->username)->where('is_active', true)->first(['email', 'phone', 'profile_pic', 'cover_pic', 'thumbnail', 'username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'language', 'address', 'country', 'id', 'user_type', 'is_active']);
        } else {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.username', $this->username)
                ->first([
                    'subcards.id',
                    'subcards.user_id',
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'subcards.cover_pic',
                    'subcards.thumbnail',
                    'users.firstname',
                    'users.lastname',
                    'users.address',
                    'users.country',
                    'users.user_type',
                    'subcards.email',
                    'subcards.phone',
                    'subcards.is_active',
                    'users.id',
                ]);
        }

        if (!isset($this->username)) {
            $this->user = 0;
        }

        // If user exist
        if ($this->user) {

            // $this->favicon = $this->user->profile_pic;
            if ($this->user->thumbnail) {
                $this->favicon = $this->user->thumbnail;
            } else {
                $this->favicon = $this->user->profile_pic;
            }

            // Set the fullanme
            $this->fullname = $this->user->firstname . ' ' . $this->user->lastname;
            $this->is_active = $this->user->is_active;

            //if user exist, get contact points
            $this->contacts = Button::where($this->condition)
                ->where('is_active', true)
                ->where('view', 'contacts')
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get events
            $this->event = Event::where('is_active', true)
                ->where($this->condition)
                ->where('slug', $this->slug)
                ->orderBy('order', 'asc')
                ->first();

            //if user exist, get direction links
            $this->directions = Button::where('is_active', true)
                ->where($this->condition)
                ->where('view', 'directions')
                ->orderBy('order', 'asc')
                ->get();

            // Card title
            $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Page title
            $this->page_title = UserSettings::where('setting_key', 'custom_page_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //Settings: Footer set by the user
            $this->footer_text = UserSettings::where('setting_key', 'footer_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->footer_link = UserSettings::where('setting_key', 'footer_link')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();


            if ($this->contacts->isEmpty()) {
                $this->contacts = 0;
            }

            // if NULL, set to TRUE
            // $this->services_price_enabled = $this->services_price_enabled ?? true;
            $this->event_title = $this->event->title ?? '';

            //if footer text and link not already set, set to true
            if ($this->footer_text == NULL && $this->footer_link == NULL) {
                $this->showFooter = true;
            }

            if ($this->footer_text && $this->footer_link) {
                $this->showFooter = true;
            }

            if (!$this->card_title) {
                $this->card_title = $this->fullname;
            }

            if ($this->directions->isEmpty()) {
                $this->directions = 0;
            }

            if (!$this->page_title) {
                $this->page_title = $this->card_title;
            }

            if (!$this->event) {
                // $this->event = 0;
                abort(404, 'Event not found.');
                $this->event_title = '';
                $this->card_title = "Event not found";
            }
        } else {
            $this->user = 0;
            $this->event_title = '';
            $this->card_title = "Event not found";
        }
    }

    public function __construct()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;

        $this->default_footer_text = $default->footer_text;
        $this->default_footer_link = $default->footer_link;
        $this->ad_banner_w = $default->ad_banner_w;
        $this->ad_banner_h = $default->ad_banner_h;
    }

    public function mount($username, $slug)
    {
        //used to determine where to check if the username exist
        $this->checkMain = User::where('username', $this->username)->count();
        $this->checkSub = SubCard::where('username', $this->username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();
            $this->condition = ['user_id' => $this->user_id, 'page_id' => NULL];
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('username', $this->username)
                ->pluck('id')
                ->first();
            $this->mainCard = false;
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->getAds = true;

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Text Color Settings
        $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_link = UserSettings::where('setting_key', 'color_settings_link')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->products = Product::where($this->condition)
            ->where('is_active', true)
            ->get();

        //profile layout
        $this->profile_layout = UserSettings::where('setting_key', 'profile_layout')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        //username
        $this->username_enabled = UserSettings::where('setting_key', 'display_username')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Short Bio enabled
        $this->short_bio_enabled = UserSettings::where('setting_key', 'display_short_bio')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->display_country = UserSettings::where('setting_key', 'display_country')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->button_style = UserSettings::where('setting_key', 'button_style')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
        $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
        $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
        $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';
        $this->color_settings_link = $this->color_settings_link ?: '#ca8a04';
        $this->profile_layout = $this->profile_layout ?? 'default';
        $this->username_enabled = $this->username_enabled ?? true;
        $this->short_bio_enabled = $this->short_bio_enabled ?? true;
        $this->display_country = $this->display_country ?? true;
        //style
        $this->button_style = $this->button_style ?: 'rounded';

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->displayEvent($username, $slug);

        // Decode saved contact_settings from the event
        // $this->contact_settings = json_decode($this->event->contact_settings ?? '{}', true);
        $this->contact_settings = $this->event->contact_settings ?? [];

        // Optional: ensure all contacts have an entry (default false if missing)
        if ($this->contacts) {
            foreach ($this->contacts as $contact) {
                if (!isset($this->contact_settings[$contact->id])) {
                    $this->contact_settings[$contact->id] = false;
                }
            }
        }

        if ($this->getAds && $this->is_active) {
            if ($this->user->user_type == 'Free') {
                // ads for free cards
                $this->ads_top = Ad::where('is_active', true)
                    ->where('position', 'top')
                    ->where('is_admin', true)
                    ->where('display_in', 'Free')
                    ->ordered()
                    ->get();

                $this->ads_bottom = Ad::where('is_active', true)
                    ->where('position', 'bottom')
                    ->where('is_admin', true)
                    ->where('display_in', 'Free')
                    ->ordered()
                    ->get();
            }
            // Basic card who own ads
            else if ($this->user->user_type == "Basic") {
                // else if ($this->user_type == "Basic" && !$referred_id) {
                $this->ads_top = Ad::where('is_active', true)->where('is_admin', false)
                    ->where('user_id', $this->user->id)
                    ->where('page_id', NULL)
                    ->where('position', 'top')
                    ->ordered()->get();

                $this->ads_bottom = Ad::where('is_active', true)->where('is_admin', false)
                    ->where('user_id', $this->user->id)
                    ->where('page_id', NULL)
                    ->where('position', 'bottom')
                    ->ordered()->get();
            } else if ($this->user->user_type == "Sponsored") {
                // ads for sponsored card
                $this->ads_top = Ad::where('is_active', true)
                    ->where('position', 'top')
                    ->where('is_admin', true)
                    ->where('display_in', 'Sponsored')
                    ->where('sponsor_id', $this->sponsor_id)
                    ->ordered()
                    ->get();

                $this->ads_bottom = Ad::where('is_active', true)
                    ->where('display_in', 'Sponsored')
                    ->where('sponsor_id', $this->sponsor_id)
                    ->where('position', 'bottom')
                    ->where('is_admin', true)
                    ->ordered()
                    ->get();
            } else if (in_array($this->user->user_type, ['Gold', 'Platinum']) && $this->mainCard) {
                // if user_type not free and main card
                // get all ads on position = top
                $this->ads_top = Ad::where('is_active', true)
                    ->where('is_admin', false)
                    ->where('user_id', $this->user->id)
                    ->where('page_id', NULL)
                    ->where('position', 'top')
                    ->ordered()
                    ->get();

                // get all ads on position = top
                $this->ads_bottom = Ad::where('is_active', true)
                    ->where('is_admin', false)
                    ->where('user_id', $this->user->id)
                    ->where('page_id', NULL)
                    ->where('position', 'bottom')
                    ->ordered()
                    ->get();
            } else {
                // if  sub card
                // get all ads on position = top
                $this->ads_top = Ad::where('is_active', true)
                    ->where('is_admin', false)
                    ->where('user_id', $this->user->id)
                    ->where('page_id', $this->page_id)
                    ->where('position', 'top')
                    ->ordered()
                    ->get();

                // get all ads on position = top
                $this->ads_bottom = Ad::where('is_active', true)
                    ->where('is_admin', false)
                    ->where('user_id', $this->user->id)
                    ->where('page_id', $this->page_id)
                    ->where('position', 'bottom')
                    ->ordered()
                    ->get();
            }
        }
    }

    public function render()
    {
        // dd($this->user->cover_pic);
        $this->videos = $this->event->event_video_link ?? [];
        // dd($this->videos);
        $this->video_count = count($this->videos);
        $event_image = $this->event->event_poster ?? $this->favicon;
        return view('livewire.event-info-page')->title($this->event_title . ' | ' . ($this->page_title ?? $this->card_title))->layoutData([
            // 'favicon' => $this->favicon,
            'favicon' => $event_image,
            'username' => $this->username,
            'site_url' => $this->site_url,
            // 'thumbnail' => $this->thumbnail,
            'thumbnail' => $event_image,
            'ads_top' => $this->ads_top,
            'ads_bottom' => $this->ads_bottom,
            'title' => $this->page_title ?: $this->card_title,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
            'color_settings_profile_pic_border' => $this->color_settings_profile_pic_border,
            'app_name' => $this->app_name,
        ]);
    }
}
