<?php

namespace App\Livewire;

use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use Illuminate\Support\Facades\Password;

class ForgotPassword extends Component
{

    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;
    public $site_desc;
    public $email;

    protected $rules = [
        'email' => 'required|email|exists:users,email',
    ];

    protected $messages = [
        'email.exists' => 'User with the email ":input" doesn\'t exist.',
    ];

    public function sendResetLink()
    {
        $this->validate();

        $status = Password::sendResetLink(
            ['email' => $this->email]
        );

        if ($status === Password::RESET_LINK_SENT) {
            session()->flash('success', __($status));
            $this->reset('email');
        } else {
            session()->flash('error', __($status));
        }
    }


    public function render()
    {
        $default = app(CardDefaultsSetting::class);

        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->site_desc = $default->site_desc;
        $this->app_name = $default->app_name;

        return view('livewire.forgot-password')->title('Forgot Password ' . $this->site_name)->layoutData([
            'site_name' => $this->site_name,
            'site_url' => $this->site_url,
            'site_desc' => $this->site_desc,
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
