<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\SubCard;
use App\Models\User;
use App\Models\Image;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;

class ImageManager extends Component
{
    use AuthorizesRequests;

    public $user;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $checkifactive, $images_count;

    public $images;
    public $favicon;
    public $page_id; //subcard id, used in query

    public function runImageManager()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        // if active, get the datas and set to form
        if ($this->checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic', 'thumbnail', 'user_type']);

            $this->images_count = Image::where('user_id', auth()->user()->id)->whereNull('page_id')->count();
        } else {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.user_id', auth()->user()->id)
                ->where('subcards.active_card', true)
                ->first([
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'subcards.thumbnail',
                    'users.firstname',
                    'users.lastname',
                    'users.user_type',
                ]);
            // if main card is not active, get the infos from subcard
            // $this->maincard_active = false;
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->images_count = Image::where('page_id', $this->page_id)->count();
        }

        if ($this->user) {

            if ($this->user->thumbnail) {
                $this->favicon = $this->user->thumbnail;
            } else {
                $this->favicon = $this->user->profile_pic;
            }
        }
    }

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->runImageManager();
    }

    public function render()
    {
        // dd($this->images_count);
        $this->authorize('view', Image::class);
        return view('livewire.image-manager')->title('Images | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
            // 'favicon' => $this->favicon,
        ]);
    }
}
