<?php

namespace App\Livewire;

use App\Models\User;
use App\Models\SubCard;
use App\Settings\CardDefaultsSetting;
use App\Models\UserSettings;
use Livewire\Component;
use Illuminate\Support\Facades\Auth;

class LayoutPage extends Component
{
    public $site_url;
    public $site_name;
    public $app_name;
    public $thumbnail;

    public $user;
    public $user_type_get;
    public $username;
    public $page_id;

    // Layout
    public $button_style;
    public $condition;
    public $checkifActive;

    public function viewLayout()
    {
        $this->button_style = UserSettings::where('setting_key', 'button_style')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();
    }

    public function updateLayout()
    {
        if (!auth()->check()) {
            session()->flash('error', 'Unauthorized action.');
            return redirect()->route('dashboard.layout');
        }

        try {
            $updated = UserSettings::where($this->condition)
                ->where('setting_key', 'button_style')
                ->update([
                    'setting_value' => $this->button_style
                ]);

            if ($updated) {
                session()->flash('success', 'Layout successfully updated.');
            } else {
                session()->flash('error', 'No changes were made.');
            }

            return redirect()->route('dashboard.layout');
        } catch (\Exception $e) {
            session()->flash('error', $e->getMessage());
            return redirect()->route('dashboard.layout');
        }
    }

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_url = $default->site_url;
        $this->site_name = $default->site_name;
        $this->app_name = $default->app_name;
        $this->thumbnail = $default->thumbnail;

        // Check if main card is active
        $this->checkifActive = User::where('id', auth()->user()->id)
            ->where('active_card', true)
            ->count();

        if ($this->checkifActive > 0) {
            // Get main user data
            $this->user = User::where('id', Auth::user()->id)
                ->select('id', 'username', 'user_type')
                ->first();

            $this->user_type_get = $this->user->user_type;
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => null];
        } else {
            // Get active subcard data
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.user_id', auth()->user()->id)
                ->where('subcards.active_card', true)
                ->select(
                    'subcards.id',
                    'subcards.username',
                    'users.user_type'
                )
                ->first();

            $this->user_type_get = $this->user->user_type;
            $this->page_id = $this->user->id;
            $this->condition = ['page_id' => $this->page_id];
        }

        // Load previous button style
        $this->viewLayout();

        $this->username = $this->user->username;
    }

    public function render()
    {
        return view('livewire.layout-page')
            ->title('Edit Profile | ' . $this->site_name)
            ->layoutData([
                'app_name' => $this->app_name,
                'thumbnail' => $this->thumbnail,
            ]);
    }
}
