<?php

namespace App\Livewire;

use App\Models\Member;
use App\Models\SubCard;
use App\Models\User;
use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use Illuminate\Support\Facades\DB;
use Livewire\WithPagination;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class MembersPage extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $members;
    public $added;
    public $submission;

    public $user_type;

    public $user;
    public $checkifactive;
    public $page_id, $members_count; //subcard id, used in query

    public function getFeedback($id)
    {
        $this->dispatch('feedback_id', $id);
    }

    public function getMembers()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();



        if ($this->checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first();
            $networkCondition = ['members.user_id' => auth()->user()->id];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->user = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->first();;
            $networkCondition = ['members.page_id' => $this->page_id];
        }
        // dd($this->user->username);

        $this->members_count = Member::where($networkCondition)->count();
        //     ->where('members.card_type', 'main')
        //     ->where($networkCondition)

        // $networksMain = Member::join('users', 'members.member_id', '=', 'users.id')
        //     ->where('members.card_type', 'main')
        //     ->where($networkCondition)
        //     ->select([
        //         'members.id as member_id',
        //         'members.card_type',
        //         'members.member_id as entity_id',
        //         'users.username',
        //         'users.firstname',
        //         'users.lastname',
        //         'users.profile_pic',
        //         'users.job_title',
        //         DB::raw('"main" as entity_type'),
        //     ]);

        // $networksSub = Member::join('subcards', 'members.member_id', '=', 'subcards.id')
        //     ->where('members.card_type', 'sub')
        //     ->where($networkCondition)
        //     ->select([
        //         'members.id as member_id',
        //         'members.card_type',
        //         'members.member_id as entity_id',
        //         'subcards.username',
        //         'subcards.firstname',
        //         'subcards.lastname',
        //         'subcards.profile_pic',
        //         'subcards.job_title',
        //         DB::raw('"sub" as entity_type'),
        //     ]);

        // $this->members = $networksMain->union($networksSub)->orderBy('firstname')->get();

        $this->user_type = auth()->user()->user_type;
    }

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->getMembers();
    }

    public function render()
    {
        // dd($this->members_count);
        // Check if user is authorize
        $this->authorize('view', Member::class);
        return view('livewire.members-page')
            ->title('Members | ' . $this->site_name)->layoutData([
                'thumbnail' => $this->thumbnail,
                'app_name' => $this->app_name,
            ]);
    }
}
