<?php

namespace App\Livewire;

use App\Models\Button;
use App\Models\LetsConnect;
use App\Models\FeedbackForm;
use App\Models\Network;
use App\Models\SubCard;
use App\Models\User;
use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use Illuminate\Support\Facades\DB;
use Livewire\WithPagination;

class NetworkPage extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $saved;
    public $added;
    public $submission;

    public $user_type;

    public $user;
    public $checkifactive;
    public $page_id; //subcard id, used in query

    public function getFeedback($id)
    {
        $this->dispatch('feedback_id', $id);
    }

    public function getNetwork()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $networkCondition = ['network.user_id' => auth()->user()->id];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $networkCondition = ['network.page_id' => $this->page_id];
        }

        $networksMain = Network::join('users', 'network.network_id', '=', 'users.id')
            ->where('network.type', 'saved')
            ->where('network.card_type', 'main')
            ->where($networkCondition)
            ->select([
                'network.id as network_id',
                'network.type',
                'network.card_type',
                'network.network_id as entity_id',
                'users.username',
                'users.firstname',
                'users.lastname',
                'users.profile_pic',
                'users.job_title',
                DB::raw('"main" as entity_type'),
            ]);

        $networksSub = Network::join('subcards', 'network.network_id', '=', 'subcards.id')
            ->where('network.type', 'saved')
            ->where('network.card_type', 'sub')
            ->where($networkCondition)
            ->select([
                'network.id as network_id',
                'network.type',
                'network.card_type',
                'network.network_id as entity_id',
                'subcards.username',
                'subcards.firstname',
                'subcards.lastname',
                'subcards.profile_pic',
                'subcards.job_title',
                DB::raw('"sub" as entity_type'),
            ]);

        $this->saved = $networksMain->union($networksSub)->orderBy('firstname')->get();


        $this->user_type = auth()->user()->user_type;
    }

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->getNetwork();
    }

    public function render()
    {
        return view('livewire.network-page')
            ->title('Network | ' . $this->site_name)->layoutData([
                'thumbnail' => $this->thumbnail,
                'app_name' => $this->app_name,
            ]);
    }
}
