<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\SubCard;

class NotificationBellComponent extends Component
{
    public $unread;

    public function render()
    {
        $activeSubCard = SubCard::where('user_id', auth()->id())
            ->where('active_card', true)
            ->first();

        if ($activeSubCard) {
            // Mark all SubCard notifications as read
            $this->unread = $activeSubCard->unreadNotifications->count();
        } else {
            $this->unread = auth()->user()->unreadNotifications->count();
        }

        return view('livewire.notification-bell-component');
    }
}
