<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\User;
use App\Models\SubCard;
use Illuminate\Support\Facades\Log;

class PaymentLinkViewModal extends Component
{
    public $username, $amount;

    public $checkMain, $checkSub, $user, $condition, $page_id;

    public function mount($username)
    {
        $this->username = $username;
        // dd('Username: ' . $this->username);
        $this->checkMain = User::where('username', $username)->count();
        $this->checkSub = SubCard::where('username', $username)->count();

        if ($this->checkMain > 0) {
            $this->user = User::where('username', $username)->where('is_active', true)->first();
            $this->condition = ['user_id' => $this->user->id, 'page_id' => NULL];
        }

        if ($this->checkSub > 0) {

            $this->page_id = SubCard::where('username', $username)->pluck('id')->first();
            $this->user = SubCard::where('id', $this->page_id)->where('is_active', true)->first();
            $this->condition = ['page_id' => $this->page_id];
        }
    }

    public function checkoutForm()
    {
        $validated = $this->validate([
            'amount' => 'required|regex:/^[0-9]+$/',
        ]);

        $message = "Hey {$this->user->firstname}, I'm ready to send a payment using Apple Pay. %0A%0A"
            . "$" . "{$this->amount}.%0A";

        $smsUrl = "sms:{$this->user->phone}?&body={$message}";
        $whatsappUrl = "https://wa.me/{$this->user->phone}?text={$message}";

        return redirect()->to($smsUrl);
    }

    public function render()
    {
        return view('livewire.payment-link-view-modal');
    }
}
