<?php

namespace App\Livewire;

use App\Models\Direction;
use App\Models\SubCard;
use App\Models\User;
use App\Models\PresentationPage;
use Livewire\Component;
use App\Settings\CardDefaultsSetting;

class PresentationPageDashboard extends Component
{
    public $user;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $pages;
    public $user_type;

    public $page_id; //subcard id, used in query

    public function pagesManager()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();
        // if active, get the datas and set to form
        if ($checkifactive > 0) {

            $this->user = User::where('id', auth()->user()->id)->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic', 'user_type']);

            $this->pages = PresentationPage::where('user_id', auth()->user()->id)->where('page_id', NULL)->get();
        } else {

            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.user_id', auth()->user()->id)
                ->where('subcards.active_card', true)
                ->first([
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'users.firstname',
                    'users.lastname',
                    'users.user_type',
                ]);

            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->pages = PresentationPage::where('page_id', $this->page_id)->get();
        }

        if ($this->pages->isEmpty()) {
            $this->pages = 0;
        }

        $this->user_type = auth()->user()->user_type;
    }

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->pagesManager();
    }

    public function render()
    {
        return view('livewire.presentation-page-dashboard')
            ->title('Presentation Pages | ' . $this->site_name)->layoutData([
                'thumbnail' => $this->thumbnail,
                'app_name' => $this->app_name,
            ]);
    }
}
