<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\Attributes\Validate;
use Illuminate\Database\Eloquent\Model;

class ProfilePhotoField extends Component
{
    use WithFileUploads;

    public Model $model;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]
    public $image;

    public ?string $croppedBlob;

    public $profile_pic;

    public function render()
    {
        return view('livewire.profile-photo-field');
    }
}
