<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\UserSettings;
use App\Models\SubCard;
use App\Models\User;

class ProfilePictureLayout extends Component
{
    public $page_id;
    public $checkifactive;
    public $layout, $set_layout;
    public $query;

    public function setLayout($layout)
    {
        $this->layout = $layout;
        $updated = UserSettings::updateOrCreate(
            array_merge(['setting_key' => 'profile_layout'], $this->query),
            ['setting_value' => $this->layout]
        );

        if ($updated) {
            session()->flash('success', 'Profile picture layout successfully updated!');
        }

        return redirect('/profile/edit');
    }

    public function mount()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)
            ->exists();

        if ($this->checkifactive > 0) {
            $this->query = ['user_id' => auth()->user()->id, 'page_id' => null];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            // $this->query = ['user_id' => auth()->user()->id, 'page_id' => $this->page_id];
            $this->query = ['page_id' => $this->page_id];
        }

        $this->set_layout = UserSettings::where('setting_key', 'profile_layout')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        $this->set_layout = $this->set_layout ?: 'default';
    }
    public function render()
    {
        return view('livewire.profile-picture-layout', [
            'set_layout' => $this->set_layout
        ]);
    }
}
