<?php

namespace App\Livewire;

use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use App\Models\User;
use App\Models\SubCard;
use App\Models\UserSettings;

class QrCodeModal extends Component
{
    public $username;
    public $site_url;
    public $site_name;
    public $current_url;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;
    public $user_id;

    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_link;
    public $color_settings_profile_pic_border;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $condition;

    public function mount($username)
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_url = $default->site_url;
        $this->username = $username;
        $this->current_url = url()->current(); // ✅ Get full current page URL

        // Determine where username exists
        $this->checkMain = User::where('username', $this->username)->count();
        $this->checkSub = SubCard::where('username', $this->username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();
            $this->condition = ['user_id' => $this->user_id, 'page_id' => NULL];
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('username', $this->username)->pluck('id')->first();
            $this->mainCard = false;
            $this->condition = ['page_id' => $this->page_id];
        }

        // Get user color settings
        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)->pluck('setting_value')->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)->pluck('setting_value')->first();

        $this->color_settings_link = UserSettings::where('setting_key', 'color_settings_link')
            ->where($this->condition)->pluck('setting_value')->first();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)->pluck('setting_value')->first();

        $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
            ->where($this->condition)->pluck('setting_value')->first();

        $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
            ->where($this->condition)->pluck('setting_value')->first();

        // Defaults
        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
        $this->color_settings_link = $this->color_settings_link ?: '#ca8a04';
        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
        $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
    }

    public function render()
    {
        // dd($this->current_url);
        return view('components.qr-code-modal');
    }
}
