<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Attributes\Validate;
use Livewire\Attributes\On;
use Illuminate\Database\Eloquent\Model;

class RegisterProfilePictureField extends Component
{

    use WithFileUploads;

    public Model $model;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]
    public $image;

    public ?string $croppedBlob;

    public $profile_pic;

    #[On('setRegisterImage')]
    public function setRegisterImage($croppedBlob)
    {
        $this->croppedBlob = $croppedBlob;
        // dd('Triggered set product image');
    }

    public function render()
    {
        return view('livewire.register-profile-picture-field');
    }
}
