<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\User;
use App\Models\SubCard;
use App\Models\TrustedNetwork;

class RequestAddToTrustedNetwork extends Component
{
    public $username, $condition, $user, $page_id, $subcards;
    public $selected = [];
    public $checkMain, $checkSub;

    public function mount($username)
    {
        $this->username = $username;

        // $this->checkMain = User::where('username', $username)->count();
        // $this->checkSub = SubCard::where('username', $username)->count();

        // if ($this->checkMain > 0) {
        //     $user_id = User::where('username', $username)->pluck('id')->first();
        // }

        // if ($this->checkSub > 0) {
        //     $user_id = SubCard::where('username', $username)->pluck('user_id')->first();
        // }

        // $this->user = User::where('id', $user_id)->first();
        // $this->subcards = SubCard::where('user_id', $user_id)->get();

        $this->user = User::where('id', auth()->user()->id)->first();
        $this->subcards = SubCard::where('user_id', auth()->user()->id)->get();
    }

    // public function request()
    // {
    //     $checkedSubcards = $this->selected;
    //     dd($checkedSubcards);
    //     // Get owner model (User or SubCard)
    //     $ownerModel = User::where('username', $this->username)->first()
    //         ?? SubCard::where('username', $this->username)->first();

    //     if (!$ownerModel) {
    //         session()->flash('error', 'Card owner not found.');
    //         return;
    //     }

    //     // Determine model type
    //     if ($ownerModel instanceof \App\Models\User) {
    //         $owner_type = 'main';
    //         $owner_id = $ownerModel->id;
    //     } else {
    //         $owner_type = 'sub';
    //         $owner_id = $ownerModel->id;
    //     }

    //     if (!$checkedSubcards || count($checkedSubcards) === 0) {
    //         session()->flash('error', 'Please select at least one card.');
    //         return;
    //     }

    //     try {
    //         foreach ($checkedSubcards as $subcardId) {

    //             // Prevent duplicates
    //             $exists = TrustedNetwork::where('member_id', $subcardId)
    //                 ->where(function ($q) use ($owner_type, $owner_id) {
    //                     if ($owner_type == 'main') {
    //                         $q->where('user_id', $owner_id);
    //                     } else {
    //                         $q->where('page_id', $owner_id);
    //                     }
    //                 })
    //                 ->exists();

    //             if ($exists) {
    //                 continue;
    //             }

    //             // Create record
    //             TrustedNetwork::create([
    //                 'user_id'     => $owner_type == 'main' ? $owner_id : null,
    //                 'page_id'     => $owner_type == 'sub' ? $owner_id : null,
    //                 'member_id'   => $subcardId,
    //                 'card_type'   => 'sub',
    //                 'type'        => 'network',
    //                 'is_accepted' => false,
    //             ]);
    //         }

    //         session()->flash('success', 'Requested! Card owner will be notified about the request.');
    //     } catch (\Exception $e) {
    //         session()->flash('error', $e->getMessage());
    //     }

    //     return $this->redirect(route('card.trustednetwork', $this->username), navigate: true);
    // }

    public function request()
    {
        if (empty($this->selected)) {
            session()->flash('error', 'Please select at least one card.');
            return;
        }

        foreach ($this->selected as $selected) {
            // Split type and ID
            [$card_type, $subcardId] = explode(':', $selected);

            $subcardId = (int)$subcardId; // convert to integer

            // Get owner
            $ownerModel = User::where('username', $this->username)->first()
                ?? SubCard::where('username', $this->username)->first();

            if (!$ownerModel) continue;

            $owner_type = $ownerModel instanceof User ? 'main' : 'sub';
            $owner_id   = $ownerModel->id;

            // Prevent duplicates
            $exists = TrustedNetwork::where('member_id', $subcardId)
                ->where(function ($q) use ($owner_type, $owner_id) {
                    if ($owner_type == 'main') {
                        $q->where('user_id', $owner_id);
                    } else {
                        $q->where('page_id', $owner_id);
                    }
                })->exists();

            if ($exists) continue;

            // Create record
            TrustedNetwork::create([
                'user_id'     => $owner_type == 'main' ? $owner_id : null,
                'page_id'     => $owner_type == 'sub' ? $owner_id : null,
                'member_id'   => $subcardId,
                'card_type'   => $card_type, // main or sub from checkbox
                'type'        => 'network',
                'is_accepted' => false,
            ]);
        }

        session()->flash('success', 'Requested! Card owner will be notified about the request.');
        return $this->redirect(route('card.trustednetwork', $this->username), navigate: true);
    }

    public function render()
    {
        return view('livewire.request-add-to-trusted-network');
    }
}
