<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\ProductMedia;
use App\Models\SubCard;
use App\Models\User;
use App\Models\UserSettings;

class SalesImageComponent extends Component
{
    public $images;

    public $user_id;
    public $checkMain;
    public bool $mainCard = false;
    public $user;

    public $color_settings_profile_pic_border;
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;

    public $condition;
    public $product_id;

    public function mount($username, $product_id)
    {
        $checkifactive = User::where('username', $username)->count();
        $this->product_id = $product_id;

        if ($checkifactive > 0) {
            // dd($checkifactive);

            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();
            $this->user = User::where('username', $username)->first();
            $this->condition = ['user_id' => $this->user->id, 'page_id' => NULL];
        } else {
            $this->user = SubCard::where('username', $username)->first();
            $this->condition = ['page_id' => $this->user->id];
        }

        $this->images =  ProductMedia::where('product_id', $product_id)->where('is_active', true)->where('type', 'image')->ordered()->get();
        // dd($this->images);
        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
    }

    public function render()
    {
        return view('livewire.sales-image-component');
    }
}
