<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Sale;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use App\Models\UserSettings;

class SalesPage extends Component
{
    use AuthorizesRequests;

    public $user;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;

    public $sales, $user_type;
    public $favicon;
    public $page_id; //subcard id, used in query

    public $card_title;
    public $fullname;

    public $checkifactive;
    public $condition;

    public function salesManager()
    {
        // if active, get the datas and set to form
        if ($this->checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic', 'thumbnail', 'user_type']);
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.user_id', auth()->user()->id)
                ->where('subcards.active_card', true)
                ->first([
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'subcards.thumbnail',
                    'users.firstname',
                    'users.lastname',
                    'users.user_type',
                ]);

            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }

        $this->sales = Sale::where($this->condition)->get();
        $this->user_type = auth()->user()->user_type;

        if ($this->user) {
            // Set the fullanme
            $this->fullname = $this->user->firstname . ' ' . $this->user->lastname;

            if ($this->user->thumbnail) {
                $this->favicon = $this->user->thumbnail;
            } else {
                $this->favicon = $this->user->profile_pic;
            }

            if ($this->sales->isEmpty()) {
                $this->sales = 0;
            }

            if ($this->checkifactive > 0) {
                // Card title
                $this->card_title = UserSettings::where('user_id', $this->user->id)
                    ->where('page_id', NULL)
                    ->where('setting_key', 'card_custom_title')
                    ->pluck('setting_value')
                    ->first();
            } else {
                // Card title
                $this->card_title = UserSettings::where('user_id', $this->user->id)
                    ->where('setting_key', 'card_custom_title')
                    ->where('page_id', $this->page_id)
                    ->pluck('setting_value')
                    ->first();
            }

            if (!$this->card_title) {
                $this->card_title = $this->fullname;
            }
        } else {
            $this->user = 0;
            $this->card_title = "Not found";
            $this->fullname = "Not found";
        }
    }

    public function mount()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->salesManager();
    }

    public function render()
    {
        // dd($this->sales, $this->condition);
        // Check if user is authorize
        $this->authorize('view', Sale::class);
        return view('livewire.sales-page')->title('Sales Page | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
        ]);
    }
}
