<?php

namespace App\Livewire;

use App\Models\User;
use App\Models\SubCard;
use Livewire\Attributes\Title;
use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use App\Settings\CardDefaultsSetting;
use App\Models\UserSettings;

class SettingsPage extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $user;
    public $card_title;
    public $condition;

    public function profileSettings()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'profile_pic', 'firstname', 'lastname', 'user_type']);
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->user = SubCard::where('user_id', auth()->user()->id)->where('active_card', true)->first(['username', 'firstname', 'lastname', 'profile_pic']);
            // dd($this->user);
            // $this->condition = ['user_id' => auth()->user()->id, 'page_id' => $this->user->id];
            $this->condition = ['page_id' => $this->user->id];
        }

        // Card title
        $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();
    }

    public function mount()
    {
        $this->profileSettings();
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        return view('pages.settings-page')->title('Settings | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
