<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use App\Models\Social;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Validation\ValidationException;

class SocialActionSheet extends Component
{
    public $type;
    public $link;
    public $page_id; //subcard id, used in query

    public function store($type)
    {
        try {
            $this->type = $type;

            // Add the user ID to the validated data
            $validated = $this->validate([
                'link' => 'required|url',
                'type' => 'required|in:facebook,x,linkedin,instagram,tiktok,youtube,clubhouse,threads,fanbase,snapchat,pinterest,soundcloud,apple_podcasts,spotify,discord,skool'
            ]);

            //save user id
            $validated['user_id'] = Auth::user()->id;

            $checkifactive = User::where('id', auth()->user()->id)
                ->where('active_card', true)->count();

            //if maincard is not active
            if ($checkifactive < 1) {
                $this->page_id = SubCard::where('user_id', auth()->user()->id)
                    ->where('active_card', true)
                    ->pluck('id')
                    ->first();
                $validated['page_id'] = $this->page_id;
            }

            //validate before saving
            try {
                $saveSocial = Social::create($validated);
            } catch (\Exception $e) {
                // dd($e->getMessage());
                session()->flash('error', $e->getMessage());
                return redirect()->back();
            }

            if ($saveSocial && $validated['type'] == 'clubhouse') {
                session()->flash('success', 'Clubhouse successfully added!');
            } else if ($saveSocial && $validated['type'] == 'threads') {
                session()->flash('success', 'Threads successfully added!');
            } else if ($saveSocial && $validated['type'] == 'pinterest') {
                session()->flash('success', 'Pinterest successfully added!');
            } else if ($saveSocial && $validated['type'] == 'fanbase') {
                session()->flash('success', 'Fanbase successfully added!');
            } else if ($saveSocial && $validated['type'] == 'snapchat') {
                session()->flash('success', 'Snapchat successfully added!');
            } else if ($saveSocial && $validated['type'] == 'facebook') {
                session()->flash('success', 'Facebook successfully added!');
            } else if ($saveSocial && $validated['type'] == 'x') {
                session()->flash('success', 'Twitter X successfully added!');
            } else if ($saveSocial && $validated['type'] == 'linkedin') {
                session()->flash('success', 'LinkedIn successfully added!');
            } else if ($saveSocial && $validated['type'] == 'tiktok') {
                session()->flash('success', 'Tiktok successfully added!');
            } else if ($saveSocial && $validated['type'] == 'youtube') {
                session()->flash('success', 'Youtube successfully added!');
            } else if ($saveSocial && $validated['type'] == 'instagram') {
                session()->flash('success', 'Instagram successfully added!');
            } else if ($saveSocial && $validated['type'] == 'soundcloud') {
                session()->flash('success', 'SoundCloud successfully added!');
            } else if ($saveSocial && $validated['type'] == 'apple_podcasts') {
                session()->flash('success', 'Apple Podcasts successfully added!');
            } else if ($saveSocial && $validated['type'] == 'spotify') {
                session()->flash('success', 'Spotify successfully added!');
            } else if ($saveSocial && $validated['type'] == 'discord') {
                session()->flash('success', 'Discord successfully added!');
            } else if ($saveSocial && $validated['type'] == 'skool') {
                session()->flash('success', 'Skool successfully added!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }

            return $this->redirect('/dashboard/social', navigate: true);
        } catch (ValidationException $e) {
            // stop spinner on validation errors
            $this->dispatch('set-submitting', ['value' => false]);
            throw $e;
        }
    }

    public function render()
    {
        return view('components.social-action-sheet');
    }
}
