<?php

namespace App\Livewire;

use App\Models\Social;
use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\On;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Validation\ValidationException;

class SocialEdit extends Component
{
    public $link;
    public $type;
    public $id;
    public $page_id; //subcard id, used in query

    public function store($type)
    {
        try {
            $this->type = $type;
            $validated = $this->validate([
                'link' => 'required|string',
                'type' => 'required|in:facebook,x,linkedin,instagram,tiktok,youtube,clubhouse,threads,fanbase,snapchat,pinterest,soundcloud,apple_podcasts,spotify,discord,skool'
            ]);

            $validated['user_id'] = Auth::user()->id;

            $checkifactive = User::where('id', auth()->user()->id)
                ->where('active_card', true)->count();

            //if maincard is not active
            if ($checkifactive < 1) {
                $this->page_id = SubCard::where('user_id', auth()->user()->id)
                    ->where('active_card', true)
                    ->pluck('id')
                    ->first();
                $validated['page_id'] = $this->page_id;
            }

            //validate before updating
            try {
                $update = Social::where('id', $this->id)
                    ->where('user_id', auth()->id())
                    ->firstOrFail();

                $update->update([
                    // 'title' => $validated['title'],
                    'link' => $validated['link'],
                    'type' => $validated['type'],
                    // 'view' => $validated['view'],
                ]);
            } catch (\Exception $e) {
                // dd($e->getMessage());
                session()->flash('error', $e->getMessage());
                return redirect()->back();
            }
            if ($update && $validated['type'] == 'clubhouse') {
                session()->flash('success', 'Clubhouse successfully updated!');
            } else if ($update && $validated['type'] == 'threads') {
                session()->flash('success', 'Threads successfully updated!');
            } else if ($update && $validated['type'] == 'pinterest') {
                session()->flash('success', 'Pinterest successfully updated!');
            } else if ($update && $validated['type'] == 'snapchat') {
                session()->flash('success', 'Snapchat successfully updated!');
            } else if ($update && $validated['type'] == 'fanbase') {
                session()->flash('success', 'Fanbase successfully updated!');
            } else if ($update && $validated['type'] == 'facebook') {
                session()->flash('success', 'Facebook successfully updated!');
            } else if ($update && $validated['type'] == 'x') {
                session()->flash('success', 'Twitter X successfully updated!');
            } else if ($update && $validated['type'] == 'linkedin') {
                session()->flash('success', 'LinkedIn successfully updated!');
            } else if ($update && $validated['type'] == 'tiktok') {
                session()->flash('success', 'Tiktok successfully updated!');
            } else if ($update && $validated['type'] == 'youtube') {
                session()->flash('success', 'Youtube successfully updated!');
            } else if ($update && $validated['type'] == 'instagram') {
                session()->flash('success', 'Instagram successfully updated!');
            } else if ($update && $validated['type'] == 'soundcloud') {
                session()->flash('success', 'SoundCloud successfully updated!');
            } else if ($update && $validated['type'] == 'apple_podcasts') {
                session()->flash('success', 'Apple Podcasts successfully updated!');
            } else if ($update && $validated['type'] == 'spotify') {
                session()->flash('success', 'Spotify successfully updated!');
            } else if ($update && $validated['type'] == 'discord') {
                session()->flash('success', 'Discord successfully updated!');
            } else if ($update && $validated['type'] == 'skool') {
                session()->flash('success', 'Skool successfully updated!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }

            return $this->redirect('/dashboard/social', navigate: true);
        } catch (ValidationException $e) {
            // stop spinner on validation errors
            $this->dispatch('set-submitting', ['value' => false]);
            throw $e;
        }
    }

    #[On('send_link')]
    public function displayLinkOnModal($link)
    {
        $this->link = $link;
    }

    #[On('send_id')]
    public function set_edit_id($id)
    {
        $this->id = $id;
    }

    public function render()
    {
        return view('components.social-edit');
    }
}
