<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Analytics;
use App\Models\User;
use App\Models\SubCard;
use Carbon\Carbon;
use App\Models\UserSettings;

class SocialIconComponent extends Component
{
    public $social_id;
    public $social_type;
    public $user_id;
    public $username;
    public $link;
    public $title;

    public bool $mainCard = false;
    public $page_id;
    public $user;
    public $checkMain;
    public $checkSub;
    protected $listeners = ['buttonClicked'];

    // public $color_settings_custom_button;
    // public $color_settings_custom_button_text;

    // public $condition;
    public $query;

    public function buttonClicked($social_id, $device, $location)
    {
        // dd($this->user_id, $this->page_id, $social_id, $device, $location['ip'], $location['city'], $location['region'], $location['country']);
        if ($this->mainCard == true) {
            $this->query = ['user_id' => $this->user_id, 'page_id' => NULL];
            //main card

        } else {
            //subcard
            // $this->query = ['user_id' => $this->user_id, 'page_id' => $this->page_id];
            $this->query = ['page_id' => $this->page_id];
        }

        $existingClick = Analytics::where('ip_address', $location['ip'] ?? null)
            ->where($this->query)
            ->where('device_type', $device)
            ->where('social_id', $social_id)
            ->where('type', 'social_click')
            ->whereDate('clicked_at', Carbon::today())
            ->first();

        if (!$existingClick) {
            Analytics::create(array_merge(
                [
                    'social_id'   => $social_id,
                    'device_type' => $device,
                    'ip_address'  => $location['ip'] ?? null,
                    'city'        => $location['city'] ?? null,
                    'region'      => $location['region'] ?? null,
                    'country'     => $location['country'] ?? null,
                    'clicked_at'   => now(),
                    'type'        => 'social_click'
                ],
                $this->query
            ));
        }
    }

    public function mount($username)
    {
        //used to determine where to check if the username exist
        $this->checkMain = User::where('username', $username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();

            // $this->condition = ['user_id' => $this->user_id, 'page_id' => NULL];
        } else {
            $this->mainCard = false;
            $this->page_id = SubCard::where('username', $username)
                ->pluck('id')
                ->first();

            $this->user_id = SubCard::where('username', $username)
                ->pluck('user_id')
                ->first();

            // $this->condition = ['user_id' => NULL, 'page_id' => $this->page_id];
        }


        // $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
        //     ->where($this->condition)
        //     ->pluck('setting_value')
        //     ->first();

        // $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
        //     ->where($this->condition)
        //     ->pluck('setting_value')
        //     ->first();

        // $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        // $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
    }

    public function render()
    {
        return view('livewire.social-icon-component');
    }
}
