<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Ad;
use App\Models\SubCard;
use App\Models\User;

class SortableAds extends Component
{
    public $ad_id;
    public $image;
    public $link;
    public $caption;
    public $position, $order, $is_active;
    public $ads;
    public $page_id;
    public $condition;

    public function activate($ad_id)
    {
        $ad = Ad::where('id', $ad_id)
            ->where($this->condition)
            ->where('is_admin', false)
            ->first();

        if ($ad) {
            //If true, change to false. If false, change to true
            $ad['is_active'] = !$ad['is_active'];
            $ad->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/ads', navigate: true);
    }

    public function delete($ad_id)
    {
        $check = Ad::where('id', $ad_id)
            ->where($this->condition)
            ->where('is_admin', false)
            ->first();

        if ($check) {
            $check->delete();
            session()->flash('success', 'Ad successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/dashboard/ads', navigate: true);
    }

    public function getLink($id)
    {
        $ad = Ad::where('id', $id)
            ->where($this->condition)
            ->where('is_admin', false)
            ->first(['id', 'image', 'link', 'caption', 'position', 'order', 'is_active']);

        //assign ad value
        $this->link = $ad->link;
        $this->caption = $ad->caption;
        $this->image = $ad->image;
        $this->position = $ad->position;
        // $this->order = $ad->order;
        $this->is_active = $ad->is_active;
    }

    public function updateOrder(array $order)
    {
        // Button::where('user_id', auth()->user()->id) . setNewOrder($order);
        Ad::setNewOrder($order, 1, 'id', function ($query) {
            $query->whereBelongsTo(auth()->user());
        });
    }

    public function render()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->ads = Ad::where('is_admin', false)->where($this->condition)->ordered()->get();

        return view('livewire.sortable-ads', [
            'ads' => $this->ads
        ]);
    }
}
