<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Button;
use App\Models\SubCard;
use App\Models\User;

class SortableButton extends Component
{
    public $button_id;
    public $link;
    public $title;
    public $buttons;
    public $page_id;
    public $user;
    public $condition;

    public function activate($button_id)
    {
        $button = Button::where('id', $button_id)
            ->where($this->condition)
            ->first();

        if ($button) {
            //If true, change to false. If false, change to true
            $button['is_active'] = !$button['is_active'];
            $button->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/button', navigate: true);
    }

    public function delete($button_id)
    {
        $check = Button::where('id', $button_id)
            ->where($this->condition)
            ->first();

        if ($check) {
            $check->delete();
            session()->flash('success', 'Button successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/dashboard/button', navigate: true);
    }

    public function getLink($id)
    {
        $button = Button::where('id', $id)->first(['link', 'title']);
        $this->link = $button->link;
        $this->title = $button->title;

        //Send to ButtonEditActionSheet
        $this->dispatch('send_link', $this->link);
        $this->dispatch('send_title', $this->title);
        $this->dispatch('send_id', $id);
    }

    public function updateOrder(array $order)
    {
        // Button::where('user_id', auth()->user()->id) . setNewOrder($order);
        Button::setNewOrder($order, 1, 'id', function ($query) {
            $query->whereBelongsTo($this->user);
        });
    }

    public function mount()
    {
        $this->user = auth()->user();
    }

    public function render()
    {
        $checkifactive = User::where('id', $this->user->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', $this->user->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->buttons = Button::where($this->condition)->where('view', 'links')->ordered()->get();

        return view('livewire.sortable-button', [
            'buttons' => $this->buttons
        ]);
    }
}
