<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\ProductCollection;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class SortableCollection extends Component
{
    use AuthorizesRequests;

    public $collection_id;
    public $title;

    public $page_id;
    public $collections;
    public $condition;
    public $checkifactive;

    public function activate($collection_id)
    {
        $this->collection_id = $collection_id;

        $collection = ProductCollection::where('id', $this->collection_id)
            ->where($this->condition)
            ->first();

        if ($collection) {
            $collection['is_active'] = !$collection['is_active'];
            $collection->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/product', navigate: true);
    }

    public function delete($collection_id)
    {
        // Check if user is authorize
        // $this->authorize('delete', ProductCollection::class);
        $this->collection_id = $collection_id;
        //check if button exist and belongs to the user
        $collection = ProductCollection::where('id', $this->collection_id)->where($this->condition)->first();

        if ($collection) {
            $collection->delete();
            session()->flash('success', 'Collection successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/product', navigate: true);
    }

    public function updateOrder(array $order)
    {
        // ProductCollection::setNewOrder($order, 1, 'id', function ($query) {
        //     $query->whereBelongsTo(auth()->user());
        // });

        if ($this->checkifactive > 0) {
            ProductCollection::setNewOrder($order, 1, 'id', function ($query) {
                $query->whereBelongsTo(auth()->user());
            });
        } else {
            ProductCollection::setNewOrder($order, 1, 'id', function ($query) {
                $query->where('page_id', $this->page_id);
            });
        }
    }

    public function render()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }

        $this->collections =  ProductCollection::where($this->condition)->ordered()->get();

        // $this->authorize('view', ProductCollection::class);
        return view('livewire.sortable-collection', [
            'collections' => $this->collections
        ]);
    }
}
