<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Image;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\Storage;

class SortableImages extends Component
{
    use AuthorizesRequests;

    public $image_id;
    public $link;
    public $title;

    public $page_id;
    public $images;

    public $checkifactive;
    public $condition;

    public function activate($image_id)
    {
        $this->image_id = $image_id;

        // Determine query based on active state
        $image = Image::where('id', $this->image_id)->where($this->condition)->first();

        if (!$image) {
            session()->flash('error', 'Unauthorized action or image not found.');
            return $this->redirect('/dashboard/images', navigate: true);
        }

        try {
            $image['is_active'] = !$image['is_active'];
            $image->save();
        } catch (\Exception $e) {
            session()->flash('error', 'Error deleting image.');
        }

        return $this->redirect('/dashboard/images', navigate: true);
    }

    public function delete($image_id)
    {
        // Find image based on active state
        $image = Image::where('id', $image_id)->where($this->condition)->first();

        if (! $image) {
            session()->flash('error', 'Unauthorized action or image not found.');
            return $this->redirect('/dashboard/images', navigate: true);
        }

        // Authorize against the specific model instance
        $this->authorize('delete', $image);

        try {
            // Delete file if it exists
            if ($image->image_path && Storage::disk('public')->exists($image->image_path)) {
                Storage::disk('public')->delete($image->image_path);
            }

            // Delete the DB record
            $image->delete();

            session()->flash('success', 'Image successfully deleted!');
        } catch (\Exception $e) {
            session()->flash('error', 'Error deleting image.');
        }

        return $this->redirect('/dashboard/images', navigate: true);
    }

    public function updateOrder(array $order)
    {
        if ($this->checkifactive > 0) {
            Image::setNewOrder($order, 1, 'id', function ($query) {
                $query->whereBelongsTo(auth()->user());
            });
        } else {
            Image::setNewOrder($order, 1, 'id', function ($query) {
                $query->where('page_id', $this->page_id);
            });
        }
    }

    public function render()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }

        $this->images = Image::where($this->condition)->ordered()->get();

        // Check if user is authorize
        $this->authorize('view', Image::class);
        return view('livewire.sortable-images', [
            'images' => $this->images
        ]);
    }
}
