<?php

namespace App\Livewire;

use App\Models\Button;
use Livewire\Component;
use App\Models\LeadCaptureForm;
use App\Models\SubCard;
use App\Models\User;

class SortableLeadCaptureForm extends Component
{
    public $page_id;
    public $forms;

    public $checkifactive, $condition;

    public function delete($form_id)
    {
        $check = LeadCaptureForm::where('id', $form_id)
            ->where($this->condition)
            ->first();

        if ($check) {
            LeadCaptureForm::where('id', $form_id)->delete();
            $check->delete();

            session()->flash('success', 'Form successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/dashboard/forms', navigate: true);
    }

    public function render()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->forms = LeadCaptureForm::where($this->condition)
            ->orderBy('created_at', 'desc')
            ->get();

        return view('livewire.sortable-lead-capture-form', [
            'forms' => $this->forms
        ]);
    }
}
