<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Direction;
use App\Models\SubCard;
use App\Models\User;
use App\Models\PresentationPage;

class SortablePresentationPages extends Component
{
    public $button_id;
    public $link;
    public $title;

    public $page_id;
    public $pages;
    public $condition;
    public $username;
    public $checkifactive;

    public function activate($page_id)
    {
        $page = PresentationPage::where('id', $page_id)
            ->where($this->condition)
            ->first();

        if ($page) {
            $page['is_active'] = !$page['is_active'];
            $page->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/pages', navigate: true);
    }

    public function delete($page_id)
    {
        $page = PresentationPage::where('id', $page_id)
            ->where($this->condition)
            ->first();

        if ($page) {
            $page->delete();
            session()->flash('success', 'Page successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/dashboard/pages', navigate: true);
    }

    public function updateOrder(array $order)
    {
        if ($this->checkifactive > 0) {
            PresentationPage::setNewOrder($order, 1, 'id', function ($query) {
                $query->where('user_id', auth()->user()->id);
            });
        } else {
            PresentationPage::setNewOrder($order, 1, 'id', function ($query) {
                $query->where('page_id', $this->page_id);
            });
        }
    }

    public function mount()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
            $this->username = User::where('id', auth()->user()->id)->pluck('username')->first();
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->username = SubCard::where('user_id', auth()->user()->id)->where('active_card', true)->pluck('username')->first();
            $this->condition = ['page_id' => $this->page_id];
        }
    }

    public function render()
    {
        $this->pages =  PresentationPage::where($this->condition)->ordered()->get();
        return view('livewire.sortable-presentation-pages', [
            'pages' => $this->pages
        ]);
    }
}
