<?php

namespace App\Livewire;

use App\Models\ProductMedia;
use Livewire\Component;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class SortableSalesImage extends Component
{
    use AuthorizesRequests;

    public $image_id;
    public $link;
    public $title;

    public $page_id;
    public $images;
    public $username;
    public $product_id;

    public function activate($image_id)
    {
        $this->image_id = $image_id;

        $image = ProductMedia::where('id', $this->image_id)
            ->first();

        if ($image) {
            //If true, change to false. If false, change to true
            $image['is_active'] = !$image['is_active'];
            $image->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        // return $this->redirect('/dashboard/sales/edit/', navigate: true);
        return $this->redirect(request()->header('Referer'), navigate: true);
    }

    public function delete($image_id)
    {
        // Find event that belongs to the user
        $image = ProductMedia::where('id', $image_id)
            ->first();

        if (! $image) {
            session()->flash('error', 'Unauthorized action.');
            // return $this->redirect('/dashboard/sales/edit', navigate: true);
            return $this->redirect(request()->header('Referer'), navigate: true);
        }

        // Authorize against the model instance
        // $this->authorize('delete', ProductMedia::class);

        $image->delete();

        session()->flash('success', 'Product image successfully deleted!');

        // return $this->redirect('/dashboard/sales/edit/', navigate: true);
        return $this->redirect(request()->header('Referer'), navigate: true);
    }

    public function updateOrder(array $order)
    {
        ProductMedia::setNewOrder($order, 1, 'id', function ($query) {
            $query->where('product_id', $this->product_id);
        });
    }

    public function mount($product_id)
    {
        $this->product_id = $product_id;
    }

    public function render()
    {
        $this->images =  ProductMedia::where('product_id', $this->product_id)->where('type', 'image')->ordered()->get();
        // Check if user is authorize
        // $this->authorize('view', SaleImage::class);
        return view('livewire.sortable-sales-image', [
            'images' => $this->images
        ]);
    }
}
