<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\ProductMedia;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class SortableSalesVideo extends Component
{
    use AuthorizesRequests;

    public $video_id;
    public $link;
    public $title;

    public $page_id;
    public $videos;
    public $username;
    public $product_id;

    public function activate($video_id)
    {
        // dd($video_id);
        $this->video_id = $video_id;

        $video = ProductMedia::where('id', $this->video_id)
            ->first();

        if ($video) {
            //If true, change to false. If false, change to true
            $video['is_active'] = !$video['is_active'];
            $video->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        // return $this->redirect('/dashboard/sales/edit/', navigate: true);
        return $this->redirect(request()->header('Referer'), navigate: true);
    }

    public function delete($video_id)
    {
        // Find event that belongs to the user
        $video = ProductMedia::where('id', $video_id)
            ->first();

        if (! $video) {
            session()->flash('error', 'Unauthorized action.');
            // return $this->redirect('/dashboard/sales/edit', navigate: true);
            return $this->redirect(request()->header('Referer'), navigate: true);
        }

        // Authorize against the model instance
        // $this->authorize('delete', ProductMedia::class);

        // Delete the sales video record
        $video->delete();

        session()->flash('success', 'Product video successfully deleted!');

        // return $this->redirect('/dashboard/sales/edit/', navigate: true);
        return $this->redirect(request()->header('Referer'), navigate: true);
    }

    public function updateOrder(array $order)
    {
        ProductMedia::setNewOrder($order, 1, 'id', function ($query) {
            $query->where('product_id', $this->product_id);
        });
    }

    public function mount($product_id)
    {
        $this->product_id = $product_id;
    }

    public function render()
    {
        $this->videos =  ProductMedia::where('product_id', $this->product_id)->where('type', 'video')->ordered()->get();

        // $this->authorize('view', ProductMedia::class);
        return view('livewire.sortable-sales-video', [
            'videos' => $this->videos
        ]);
    }
}
