<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Service;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class SortableService extends Component
{
    use AuthorizesRequests;

    public $service_id;
    public $link;
    public $title;

    public $page_id;
    public $services;
    public $condition;

    public function activate($service_id)
    {
        $this->service_id = $service_id;

        $service = Service::where('id', $this->service_id)
            ->where($this->condition)
            ->first();

        if ($service) {
            //If true, change to false. If false, change to true
            $service['is_active'] = !$service['is_active'];
            $service->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/service', navigate: true);
    }

    public function delete($service_id)
    {
        // Check if user is authorize
        $this->authorize('delete', Service::class);
        $this->service_id = $service_id;
        //check if button exist and belongs to the user
        $service = Service::where('id', $this->service_id)
            ->where($this->condition)
            ->first();

        // If exist
        if ($service) {
            //Delete
            $service->delete();
            session()->flash('success', 'Service successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/service', navigate: true);
    }

    public function updateOrder(array $order)
    {
        Service::setNewOrder($order, 1, 'id', function ($query) {
            $query->whereBelongsTo(auth()->user());
        });
    }

    public function render()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }

        $this->services =  Service::where($this->condition)->ordered()->get();

        // Check if user is authorize
        $this->authorize('view', Service::class);
        return view('livewire.sortable-service', [
            'services' => $this->services
        ]);
    }
}
