<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Social;
use App\Models\SubCard;
use App\Models\User;

class SortableSocial extends Component
{
    public $button_id;
    public $link;
    public $socials;
    public $page_id;
    public $condition;

    // function to get link and pass to edit modal
    public function getLink($id)
    {
        $this->link = Social::where('id', $id)->pluck('link')->first();
        $this->dispatch('send_link', $this->link);
        $this->dispatch('send_id', $id);
    }

    public function destroy($button_id)
    {
        $this->button_id = $button_id;
        //check if button exist and belongs to the user
        $check = Social::where('id', $this->button_id)->where($this->condition)->get();

        // If exist
        if ($check->isNotEmpty()) {
            //Delete
            Social::where('id', $this->button_id)->where($this->condition)->delete();
            session()->flash('success', 'Social link successfully deleted.');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/dashboard/social', navigate: true);
    }

    public function active($button_id)
    {
        $this->button_id = $button_id;
        $validated = $this->validate([
            'button_id' => 'required|integer'
        ]);

        $social = Social::where('id', $validated['button_id'])
            ->where($this->condition)->first();

        if ($social) {
            //If true, change to false. If false, change to true
            $social['is_active'] = !$social['is_active'];
            $social->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/dashboard/social', navigate: true);
    }

    public function updateOrder(array $order)
    {
        // Button::where('user_id', auth()->user()->id) . setNewOrder($order);
        Social::setNewOrder($order, 1, 'id', function ($query) {
            $query->whereBelongsTo(auth()->user());
        });
    }

    public function render()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->socials =  Social::where($this->condition)->ordered()->get();

        return view('livewire.sortable-social', [
            'socials' => $this->socials
        ]);
    }
}
