<?php

namespace App\Livewire;

use App\Models\Button;
use Livewire\Component;
use App\Models\Member;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Support\Facades\DB;

class SortableTeam extends Component
{
    public $image_id;
    public $link;
    public $title;

    public $page_id;
    public $teams;

    public $checkifactive, $condition;

    public function delete($button_id)
    {
        $check = Button::where('id', $button_id)
            ->where($this->condition)
            ->first();

        if ($check) {

            Member::where('team_id', $button_id)->delete();
            $check->delete();

            session()->flash('success', 'Team successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/dashboard/teams', navigate: true);
    }

    public function render()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->teams = Button::where($this->condition)->where('type', 'team')->orderBy('order')->get();
        // dd($this->teams, $this->condition);
        return view('livewire.sortable-team', [
            'teams' => $this->teams
        ]);
    }
}
