<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Member;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Support\Facades\DB;

class SortableTeamMembers extends Component
{
    // public $image_id;
    public $link;
    public $title;

    public $page_id;
    public $members;
    public $team_id;

    public $checkifactive;
    public $condition;

    public function updateOrder(array $order)
    {
        if ($this->checkifactive > 0) {
            Member::setNewOrder($order, 1, 'id', function ($query) {
                // $query->whereBelongsTo(auth()->user());
                $query->where('team_id', $this->team_id);
            });
        } else {
            Member::setNewOrder($order, 1, 'id', function ($query) {
                // $query->where('page_id', $this->page_id);
                $query->where('team_id', $this->team_id);
            });
        }
    }

    public function mount($team_id)
    {
        $this->team_id = $team_id;

        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }
    }

    public function delete($member_id)
    {
        $check = Member::where('id', $member_id)
            // ->where($this->condition)
            ->delete();

        if ($check) {
            session()->flash('success', 'Member successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        // return $this->redirect('/dashboard/teams', navigate: true);
        return $this->redirect(route('team.edit', $this->team_id), navigate: true);
    }

    public function render()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        $networksMain = Member::join('users', 'members.member_id', '=', 'users.id')
            ->where('members.card_type', 'main')
            ->where('members.team_id', $this->team_id)
            // ->where($networkCondition)
            ->select([
                'members.id as member_id',
                'members.card_type',
                'members.member_id as entity_id',
                'members.order',
                'users.username',
                'users.firstname',
                'users.lastname',
                'users.profile_pic',
                'users.job_title',
                DB::raw('"main" as entity_type'),
            ]);

        $networksSub = Member::join('subcards', 'members.member_id', '=', 'subcards.id')
            ->where('members.card_type', 'sub')
            ->where('members.team_id', $this->team_id)
            // ->where($networkCondition)
            ->select([
                'members.id as member_id',
                'members.card_type',
                'members.member_id as entity_id',
                'members.order',
                'subcards.username',
                'subcards.firstname',
                'subcards.lastname',
                'subcards.profile_pic',
                'subcards.job_title',
                DB::raw('"sub" as entity_type'),
            ]);

        $this->members = $networksMain->union($networksSub)->orderBy('order')->get();

        return view('livewire.sortable-team-members', [
            'members' => $this->members
        ]);
    }
}
