<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Models\Review;
use App\Models\SubCard;
use App\Models\User;

class SortableTestimonialVideo extends Component
{
    use AuthorizesRequests;

    public $video_id;
    public $link;
    public $title;

    public $videos;
    public $page_id, $condition;

    public function activate($video_id)
    {
        $this->video_id = $video_id;

        $video = Review::where('id', $this->video_id)
            ->where($this->condition)
            ->first();

        if ($video) {
            //If true, change to false. If false, change to true
            $video['is_active'] = !$video['is_active'];
            $video->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/video', navigate: true);
    }

    public function delete($video_id)
    {
        // Find video that belongs to the user
        $video = Review::where('id', $video_id)
            ->where($this->condition)
            ->first();

        if (! $video) {
            session()->flash('error', 'Unauthorized action.');
            return $this->redirect('/dashboard/testimonial', navigate: true);
        }

        // Authorize against the model instance
        // $this->authorize('delete', $video);

        // Delete the video record
        $video->delete();

        session()->flash('success', 'Testimonial video successfully deleted!');

        return $this->redirect('/dashboard/testimonial', navigate: true);
    }

    public function updateOrder(array $order)
    {
        Review::setNewOrder($order, 1, 'id', function ($query) {
            $query->whereBelongsTo(auth()->user());
        });
    }

    public function render()
    { // Check if user is authorize

        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->videos =
            Review::where($this->condition)
            ->ordered()
            ->get();

        // $this->authorize('view', Video::class);
        return view('livewire.sortable-testimonial-video', [
            'videos' => $this->videos
        ]);
    }
}
