<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Replay;
use App\Models\SubCard;
use App\Models\User;

class SortableZoomReplay extends Component
{
    public $replays;
    public $page_id;
    public $condition;
    public $checkifactive;

    public function activate($zoom_id)
    {
        $zoom_link = Replay::where('id', $zoom_id)
            ->where($this->condition)
            ->first();

        if ($zoom_link) {
            $zoom_link['is_active'] = !$zoom_link['is_active'];
            $zoom_link->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/replays', navigate: true);
    }

    public function delete($zoom_id)
    {
        $check = Replay::where('id', $zoom_id)
            ->where($this->condition)
            ->first();

        if ($check) {
            $check->delete();
            session()->flash('success', 'Zoom link successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/dashboard/replays', navigate: true);
    }

    public function updateOrder(array $order)
    {
        Replay::setNewOrder($order, 1, 'id', function ($query) {
            $query->where($this->condition);
        });
        // dd($this->checkifactive);

        // if ($this->checkifactive > 0) {
        //     Replay::setNewOrder($order, 1, 'id', function ($query) {
        //         $query->where( $this->condition);
        //     });
        // } else {
        //     Replay::setNewOrder($order, 1, 'id', function ($query) {
        //         $query->where('page_id', $this->page_id);
        //     });
        // }
    }

    public function render()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->replays = Replay::where($this->condition)->ordered()->get();

        return view('livewire.sortable-zoom-replay', [
            'replays' => $this->replays
        ]);
    }
}
