<?php

namespace App\Livewire;

use App\Models\Product;
use App\Models\ProductMedia;
use Livewire\Component;
use App\Models\User;
use App\Models\SubCard;
use App\Models\UserSettings;
use App\Settings\CardDefaultsSetting;

class SubscriptionInfoPage extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $card_title;
    public $page_title;

    public $product_title;
    public $username;
    public $id;
    public $user;
    public $fullname;
    public $favicon;
    public $product;

    public $product_price_enabled;
    public $showFooter;

    //footer by user
    public ?string $footer_text;
    public ?string $footer_link;

    //footer by user
    public ?string $default_footer_text;
    public ?string $default_footer_link;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    public $user_id;

    public $color_settings_profile_pic_border;
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    public $condition;
    public $image_count, $video_count, $images, $videos, $product_id;

    public function displayProduct($username, $id)
    {
        // get user creds
        $this->username = $username;
        $this->id = $id;

        if ($this->mainCard == true) {
            $this->user = User::where('username', $this->username)->where('is_active', true)->first(['email', 'phone', 'profile_pic', 'thumbnail', 'username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'language', 'address', 'country', 'id', 'user_type']);
        } else {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.username', $this->username)
                ->first([
                    'subcards.id',
                    'subcards.user_id',
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'subcards.thumbnail',
                    'users.firstname',
                    'users.lastname',
                    'users.address',
                    'users.country',
                    'users.user_type',
                    'subcards.email',
                    'subcards.phone',
                    'users.id',
                ]);
        }

        if (!isset($this->username)) {
            $this->user = 0;
        }

        // If user exist
        if ($this->user) {

            // $this->favicon = $this->user->profile_pic;
            if ($this->user->thumbnail) {
                $this->favicon = $this->user->thumbnail;
            } else {
                $this->favicon = $this->user->profile_pic;
            }

            // Set the fullanme
            $this->fullname = $this->user->firstname . ' ' . $this->user->lastname;

            $this->product = Product::where('is_active', true)
                ->where($this->condition)
                ->where('id', $this->id)
                ->where('type', 'subscription')
                // ->orderBy('order', 'asc')
                ->first();

            // Card title
            $this->card_title = UserSettings::where($this->condition)
                ->where('setting_key', 'card_custom_title')
                ->pluck('setting_value')
                ->first();

            // Page title
            $this->page_title = UserSettings::where('setting_key', 'custom_page_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->product_price_enabled = UserSettings::where('setting_key', 'product_price_enabled')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->footer_text = UserSettings::where('setting_key', 'footer_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->footer_link = UserSettings::where('setting_key', 'footer_link')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // if NULL, set to TRUE
            $this->product_price_enabled = $this->product_price_enabled ?? true;
            $this->product_title = $this->product->product_name ?? '';

            //if footer text and link not already set, set to true
            if ($this->footer_text == NULL && $this->footer_link == NULL) {
                $this->showFooter = true;
            }

            if ($this->footer_text && $this->footer_link) {
                $this->showFooter = true;
            }

            if (!$this->card_title) {
                $this->card_title = $this->fullname;
            }

            if (!$this->page_title) {
                $this->page_title = $this->card_title;
            }

            if (!$this->product) {
                // $this->product = 0;
                abort(404, 'Subscription not found.');
                $this->product_title = '';
                $this->card_title = "Subscription not found";
            }
        } else {
            $this->user = 0;

            $this->card_title = "Subscription not found";
        }
    }

    public function __construct()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;

        $this->default_footer_text = $default->footer_text;
        $this->default_footer_link = $default->footer_link;
    }

    public function mount($username, $id)
    {
        $this->product_id = $id;

        //used to determine where to check if the username exist
        $this->checkMain = User::where('username', $this->username)->count();
        $this->checkSub = SubCard::where('username', $this->username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();
            $this->condition = ['user_id' => $this->user_id, 'page_id' => NULL];
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('username', $this->username)
                ->pluck('id')
                ->first();
            $this->mainCard = false;
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->images = ProductMedia::where('is_active', true)
            ->where('product_id', $this->product_id)
            ->where('type', 'image')
            ->orderBy('order')
            ->get();

        $this->videos = ProductMedia::where('is_active', true)
            ->where('product_id', $this->product_id)
            ->where('type', 'video')
            ->orderBy('order')
            ->get();

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Text Color Settings
        $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
        $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
        $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
        $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
        $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;
        $this->displayProduct($username, $id);
    }

    public function render()
    {
        $this->image_count = count($this->images);
        $this->video_count = count($this->videos);

        $product_image = $this->product->featured_image ?? $this->favicon;
        return view('livewire.subscription-info-page')->title($this->product_title ?: $this->card_title)->layoutData([
            'favicon' => $product_image,
            'username' => $this->username,
            'site_url' => $this->site_url,
            'thumbnail' => $this->thumbnail,
            'title' => $this->product_title ?: $this->card_title,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
            'color_settings_profile_pic_border' => $this->color_settings_profile_pic_border,
            'app_name' => $this->app_name,
        ]);
    }
}
