<?php

namespace App\Livewire;

use Livewire\Component;

class SwitchActiveCard extends Component
{
    public $subcards;
    public $maincard;

    public function viewCardStatus()
    {
        $this->maincard = auth()->user()->active_card;
    }

    public function viewSubcards()
    {
        $this->subcards = auth()->user()->subcards()->select('id', 'username', 'job_title', 'active_card')->get();

        // $this->subcards = auth()->user()->subcards()->where('is_duplicated', false)->select('id', 'username', 'job_title', 'active_card')->get();
    }

    public function setMainCardActive()
    {
        if (auth()->user()) {
            // Set all subcards to inactive
            auth()->user()->subcards()->where('user_id', auth()->user()->id)
                ->update(['active_card' => false]);

            // set main card to active
            auth()->user()->where('id', auth()->user()->id)->update(['active_card' => true]);

            session()->flash('success', 'The card is now set as active.');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard');
        // return $this->redirect('/dashboard', navigate: true);
    }

    public function setSubCardActive($subcard_id)
    {
        if (auth()->user()) {
            // Retrieve the subcard to activate
            $activeCard = auth()->user()->subcards()->where('id', $subcard_id)
                ->where('user_id', auth()->user()->id)
                ->first();

            if ($activeCard) {
                // Set all subcards to inactive first
                auth()->user()->subcards()->where('user_id', auth()->user()->id)
                    ->update(['active_card' => false]);

                // If the 'active_card' is a field on the user model, make sure it's set to false
                // If not, this line may not be needed
                auth()->user()->where('id', auth()->user()->id)->update(['active_card' => false]);

                // Then set the specific subcard to active
                $activeCard->active_card = true;
                $activeCard->save();

                session()->flash('success', 'The card is now set as active.');
            }
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        // return $this->redirect('/dashboard', navigate: true);
        return $this->redirect('/dashboard');
    }

    public function mount()
    {
        $this->viewCardStatus();
        $this->viewSubcards();
    }

    public function render()
    {
        return view('livewire.switch-active-card', [
            'subcards' => $this->subcards,
            'maincard' => $this->maincard
        ]);
    }
}
