<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\ColorPreset;
use App\Models\UserSettings;
use App\Models\SubCard;
use App\Models\User;

class ThemeSelectionComponent extends Component
{
    public $color_presets;
    public $selected_preset;
    public $checkifactive;
    public $condition;
    public $page_id;

    // used to check colors if exist on the record
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_link;
    public $color_settings_profile_pic_border;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    // public function colorPreset($preset_id)
    // {
    //     $this->selected_preset = ColorPreset::where('is_active', true)
    //         ->where('id', $preset_id)
    //         ->first();

    //     if ($this->selected_preset) {
    //         // dd($this->selected_preset);
    //         //create or update color_settings_custom_button
    //         $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
    //             ->where($this->condition)
    //             ->pluck('setting_value')
    //             ->first();

    //         if ($this->color_settings_custom_button) {
    //             UserSettings::where($this->condition)
    //                 ->update(['setting_value' => $this->selected_preset->custom_button]);
    //         } else {
    //             UserSettings::create(array_merge(
    //                 [
    //                     'setting_key' => 'color_settings_custom_button',
    //                     'setting_value' => $this->selected_preset->custom_button,
    //                 ],
    //                 $this->condition
    //             ));
    //         }

    //         //create or update color_settings_custom_button_text
    //         $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
    //             ->where($this->condition)
    //             ->pluck('setting_value')
    //             ->first();

    //         if ($this->color_settings_custom_button_text) {
    //             UserSettings::where($this->condition)
    //                 ->update(['setting_value' => $this->selected_preset->custom_button_text]);
    //         } else {
    //             UserSettings::create(array_merge(
    //                 [
    //                     'setting_key' => 'color_settings_custom_button_text',
    //                     'setting_value' => $this->selected_preset->custom_button_text,
    //                 ],
    //                 $this->condition
    //             ));
    //         }

    //         //create or update color_settings_link
    //         $this->color_settings_link = UserSettings::where('setting_key', 'color_settings_link')
    //             ->where($this->condition)
    //             ->pluck('setting_value')
    //             ->first();

    //         if ($this->color_settings_link) {
    //             UserSettings::where($this->condition)
    //                 ->update(['setting_value' => $this->selected_preset->link]);
    //         } else {
    //             UserSettings::create(array_merge(
    //                 [
    //                     'setting_key' => 'color_settings_link',
    //                     'setting_value' => $this->selected_preset->link,
    //                 ],
    //                 $this->condition
    //             ));
    //         }

    //         //create or update color_settings_profile_pic_border
    //         $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
    //             ->where($this->condition)
    //             ->pluck('setting_value')
    //             ->first();

    //         if ($this->color_settings_profile_pic_border) {
    //             UserSettings::where($this->condition)
    //                 ->update(['setting_value' => $this->selected_preset->profile_pic_border]);
    //         } else {
    //             UserSettings::create(array_merge(
    //                 [
    //                     'setting_key' => 'color_settings_profile_pic_border',
    //                     'setting_value' => $this->selected_preset->profile_pic_border,
    //                 ],
    //                 $this->condition
    //             ));
    //         }

    //         //create or update color_settings_card_light
    //         $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
    //             ->where($this->condition)
    //             ->pluck('setting_value')
    //             ->first();

    //         if ($this->color_settings_card_light) {
    //             UserSettings::where($this->condition)
    //                 ->update(['setting_value' => $this->selected_preset->card_light]);
    //         } else {
    //             UserSettings::create(array_merge(
    //                 [
    //                     'setting_key' => 'color_settings_card_light',
    //                     'setting_value' => $this->selected_preset->card_light,
    //                 ],
    //                 $this->condition
    //             ));
    //         }

    //         //create or update color_settings_card_dark
    //         $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
    //             ->where($this->condition)
    //             ->pluck('setting_value')
    //             ->first();

    //         if ($this->color_settings_card_dark) {
    //             UserSettings::where($this->condition)
    //                 ->update(['setting_value' => $this->selected_preset->card_dark]);
    //         } else {
    //             UserSettings::create(array_merge(
    //                 [
    //                     'setting_key' => 'color_settings_card_dark',
    //                     'setting_value' => $this->selected_preset->card_dark,
    //                 ],
    //                 $this->condition
    //             ));
    //         }

    //         session()->flash('success', 'Color preset successfully updated!');
    //     } else {
    //         session()->flash('error', 'Unauthorized action.');
    //     }

    //     return redirect('/appearance/themes');
    // }

    public function colorPreset($preset_id)
    {
        $this->selected_preset = ColorPreset::where('is_active', true)
            ->where('id', $preset_id)
            ->first();

        if (!$this->selected_preset) {
            session()->flash('error', 'Unauthorized action.');
            return redirect('/appearance/themes');
        }

        $settingsMap = [
            'color_settings_custom_button' => $this->selected_preset->custom_button,
            'color_settings_custom_button_text' => $this->selected_preset->custom_button_text,
            'color_settings_link' => $this->selected_preset->link,
            'color_settings_profile_pic_border' => $this->selected_preset->profile_pic_border,
            'color_settings_card_light' => $this->selected_preset->card_light,
            'color_settings_card_dark' => $this->selected_preset->card_dark,
            'color_settings_text_light' => $this->selected_preset->text_light,
            'color_settings_text_dark' => $this->selected_preset->text_dark,
        ];

        foreach ($settingsMap as $key => $value) {
            UserSettings::updateOrCreate(
                array_merge(['setting_key' => $key], $this->condition),
                ['setting_value' => $value]
            );
        }

        session()->flash('success', 'Color preset successfully updated!');
        return redirect('/appearance/themes');
    }

    public function mount()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }
    }

    public function render()
    {
        //Color Presets
        $this->color_presets = ColorPreset::where('is_active', true)
            ->get();

        return view('livewire.theme-selection-component');
    }
}
