<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\TrustedNetwork;
use App\Models\User;
use App\Models\SubCard;
use Illuminate\Support\Facades\DB;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;

class TrustedNetworkDashboard extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $page_id, $condition, $checkifactive;

    public $team, $title, $description, $is_active;
    public $team_id;
    public $members;
    public $new_thumbnail, $old_thumbnail;

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        // dd($this->condition);
        // $this->team = TrustedNetwork::where($this->condition)
        //     ->get();

        // if (!$this->team) {
        //     abort(403, 'Access denied');
        // }

        $networksMain = TrustedNetwork::join('users', 'trusted_network.member_id', '=', 'users.id')
            ->where('trusted_network.card_type', 'main')
            ->when(isset($this->condition['user_id']), fn($q) => $q->where('trusted_network.user_id', $this->condition['user_id']))
            ->when(isset($this->condition['page_id']), fn($q) => $q->where('trusted_network.page_id', $this->condition['page_id']))
            ->select([
                'trusted_network.id as member_id',
                'trusted_network.card_type',
                'trusted_network.member_id as entity_id',
                'trusted_network.order',
                'users.username',
                'users.firstname',
                'users.lastname',
                'users.profile_pic',
                'users.job_title',
                DB::raw('"main" as entity_type'),
            ]);

        $networksSub = TrustedNetwork::join('subcards', 'trusted_network.member_id', '=', 'subcards.id')
            ->where('trusted_network.card_type', 'sub')
            ->when(isset($this->condition['user_id']), fn($q) => $q->where('trusted_network.user_id', $this->condition['user_id']))
            ->when(isset($this->condition['page_id']), fn($q) => $q->where('trusted_network.page_id', $this->condition['page_id']))
            ->select([
                'trusted_network.id as member_id',
                'trusted_network.card_type',
                'trusted_network.member_id as entity_id',
                'trusted_network.order',
                'subcards.username',
                'subcards.firstname',
                'subcards.lastname',
                'subcards.profile_pic',
                'subcards.job_title',
                DB::raw('"sub" as entity_type'),
            ]);

        $this->members = $networksMain->union($networksSub)->orderBy('order')->get();
    }

    public function render()
    {
        // dd($this->members);
        $this->authorize('view', TrustedNetwork::class);
        return view('livewire.trusted-network-dashboard')->title('Trusted Network | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'members' => $this->members,
            'app_name' => $this->app_name,
        ]);
    }
}
