<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Attributes\Validate;
use Livewire\Attributes\On;
use Illuminate\Database\Eloquent\Model;

class UpdateProductImageModal extends Component
{
    use WithFileUploads;

    public Model $model;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]

    public ?string $croppedBlob;

    public $path;

    #[On('setImage')]
    public function setImage($croppedBlob)
    {
        $this->croppedBlob = $croppedBlob;
    }

    #[On('setEditImage')]
    public function setEditImage($path)
    {
        $this->path = $path;
    }

    public function render()
    {

        return view('livewire.update-product-image-modal');
    }
}
