<?php

namespace App\Livewire;

use Livewire\Component;
use App\Settings\CardDefaultsSetting;

class UpgradeCardPlan extends Component
{
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $term_basic;
    public $term_gold;
    public $term_platinum;

    public $current_card;
    public $logo;
    public $mockup;
    public $free_trial_duration;
    public $platinum_enabled;
    public $free_trial_enabled;
    public $manual_capture_mode, $manual_capture_mode_annual_only;

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->logo = $default->logo;
        $this->app_name = $default->app_name;
        $this->mockup = $default->mockup;
        $this->free_trial_duration = $default->free_trial_duration;
        $this->platinum_enabled = $default->platinum_enabled;
        $this->free_trial_duration = $default->free_trial_duration;
        $this->free_trial_enabled = $default->free_trial_enabled;

        $this->manual_capture_mode = $default->manual_capture_mode;
        $this->manual_capture_mode_annual_only = $default->manual_capture_mode_annual_only;

        //Terms
        $this->term_basic = $default->term_basic;
        $this->term_gold = $default->term_gold;
        $this->term_platinum = $default->term_platinum;

        $this->current_card = auth()->user()->user_type;

        // dd($this->current_card, $this->platinum_enabled);
        if (!$this->platinum_enabled && $this->current_card === 'Platinum') {
            abort(403, 'Access denied');
        } else if (!$this->platinum_enabled && $this->current_card === 'Gold') {
            abort(403, 'Access denied');
        }
    }

    public function render()
    {
        // dd($this->current_card);
        // dd(auth()->user()->access, auth()->user()->user_type);
        return view('livewire.upgrade-card-plan')->title('Upgrade Card | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
