<?php

namespace App\Livewire;

use Livewire\Component;
use App\Settings\CardDefaultsSetting;

class UpgradeSuccess extends Component
{
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;
    public $logo;
    public $mockup;

    public $plan;

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->logo = $default->logo;
        $this->mockup = $default->mockup;
        $this->app_name = $default->app_name;

        // The plan info can still be displayed if passed via query string,
        // but we no longer update user_type here; it will be handled by the webhook
        // $this->plan = request()->query('plan');
    }

    public function render()
    {
        return view('livewire.upgrade-success')
            ->title('Upgrade Success | ' . $this->site_name)
            ->layoutData([
                'thumbnail' => $this->thumbnail,
                'app_name' => $this->app_name,
            ]);
    }
}
