<?php

namespace App\Livewire;

use Illuminate\Database\Eloquent\Model;
use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use Spatie\Image\Image;

class UploadGalleryImageModal extends Component
{
    use WithFileUploads;

    public Model $model;

    public $temporaryUrl;
    public ?string $croppedBlob;
    public $image_path, $image;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]

    public function handleCroppedImage($croppedBlob, $cropRegions, $imageSize)
    {
        Image::load($this->image->getRealPath())->width($imageSize['naturalWidth'])->height($imageSize['naturalHeight'])
            ->save();

        Image::load($this->image->getRealPath())
            ->manualCrop($cropRegions['width'], $cropRegions['height'], $cropRegions['x'], $cropRegions['y'])
            ->save();

        $this->croppedBlob = $croppedBlob;
        $this->dispatch('galleryImage', $this->image->getRealPath());
        //this goes to ProductImageField.php
        $this->dispatch('setImage', $this->croppedBlob);
    }

    // After uploading the image, manually validate. if image is valid, display on the modal
    public function updatedImage()
    {
        $this->image_path = $this->image;
        try {
            $this->validate([
                'image_path' => 'image|mimes:jpeg,png,jpg,webp,heif|max:5120',
            ]);

            $this->temporaryUrl = $this->image->temporaryUrl();
        } catch (\Illuminate\Validation\ValidationException $e) {
            // Handle validation failure
            session()->flash('error', 'The file must be an image (jpeg, png, jpg, heif or webp).');
            return $this->redirect('/dashboard/images', navigate: true);
        }
    }

    public function render()
    {
        return view('livewire.upload-gallery-image-modal');
    }
}
