<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Attributes\Validate;
use Livewire\Attributes\On;
use Illuminate\Database\Eloquent\Model;

class UploadImageField extends Component
{
    use WithFileUploads;

    public Model $model;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]

    public ?string $croppedBlob;

    public $image_path;

    #[On('setImage')]
    public function setImage($croppedBlob)
    {
        $this->croppedBlob = $croppedBlob;
    }

    #[On('setEditImage')]
    public function setEditImage($image_path)
    {
        $this->image_path = $image_path;
    }

    public function render()
    {

        return view('livewire.upload-image-field');
    }
}
