<?php


namespace App\Livewire;

use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;
use Illuminate\Database\Eloquent\Model;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use App\Models\User;
use App\Models\SubCard;
use Spatie\Image\Image;
use Intervention\Image\Facades\Image as ImageCompressor;
use Illuminate\Support\Facades\Storage;

class UploadImageModal extends Component
{
    use WithFileUploads;

    public Model $model;

    public $temporaryUrl;
    public ?string $croppedBlob;
    public $profile_pic;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heic,heif|max:5120')]
    public $image;

    public function handleCroppedImage($croppedBlob, $cropRegions, $imageSize)
    {
        Image::load($this->image->getRealPath())->width($imageSize['naturalWidth'])->height($imageSize['naturalHeight'])
            ->save();

        Image::load($this->image->getRealPath())
            ->manualCrop($cropRegions['width'], $cropRegions['height'], $cropRegions['x'], $cropRegions['y'])
            ->save();

        $this->croppedBlob = $croppedBlob;
        // $this->dispatch('profilePhoto', $this->image->getRealPath());
        $this->profile_pic = new TemporaryUploadedFile($this->image->getRealPath(), config('filesystems.default'));
        // dd($this->image->getRealPath(), $cropRegions, $this->profile_pic);
    }

    // public function updateProfile()
    // {

    //     // $this->validate();
    //     // check if user is logged in
    //     if (auth()->user()) {

    //         if ($this->profile_pic) {
    //             // if main card
    //             if ($this->mainCard) {
    //                 // Check if the user already has a profile picture and delete it
    //                 if (auth()->user()->profile_pic && file_exists(storage_path('app/public/' . auth()->user()->profile_pic))) {
    //                     // Delete the old profile picture
    //                     unlink(storage_path('app/public/' . auth()->user()->profile_pic));
    //                 }

    //                 auth()->user()->profile_pic = $this->profile_pic->storePublicly('profile_pic', 'public');
    //                 // Update the user data
    //                 $updated = auth()->user()
    //                     ->update([
    //                         'profile_pic' => $this->profile_pic->storePublicly('profile_pic', 'public')
    //                     ]);
    //             } else {
    //                 // if subcard
    //                 // Check if the user already has a profile picture and delete it
    //                 $checkSubCardPic = SubCard::where('active_card', true)->where('user_id', auth()->user()->id)->pluck('profile_pic')->first();

    //                 if ($checkSubCardPic && file_exists(storage_path('app/public/' . $checkSubCardPic))) {
    //                     // Delete the old profile picture
    //                     unlink(storage_path('app/public/' . $checkSubCardPic));
    //                 }

    //                 $updated = auth()->user()->subcards()
    //                     ->where('active_card', true)
    //                     ->update([
    //                         'profile_pic' => $this->profile_pic->storePublicly('profile_pic', 'public')
    //                     ]);
    //             }

    //             if ($updated) {
    //                 session()->flash('success', 'Profile picture successfully updated.');
    //             } else {
    //                 session()->flash('error', 'Error in updating profile picture.');
    //             }

    //             $tempFilePath = $this->profile_pic->getRealPath();

    //             if (file_exists($tempFilePath)) {
    //                 unlink($tempFilePath);  // Delete the temporary file explicitly
    //             }
    //         }
    //     } else {
    //         session()->flash('error', 'Unauthorized action.');
    //         // return redirect()->route('dashboard.index');

    //     }
    //     return $this->redirect('/dashboard', navigate: true);
    // }

    public function updateProfile()
    {
        if (!auth()->user()) {
            session()->flash('error', 'Unauthorized action.');
            return $this->redirect('/dashboard', navigate: true);
        }

        if (!$this->profile_pic) {
            return;
        }

        $user = auth()->user();

        // Compress the uploaded image
        $image = ImageCompressor::make($this->profile_pic->getRealPath())
            ->resize(800, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })
            ->encode('jpg', 75); // compress to 75% quality

        // Generate unique file name
        $filename = 'profile_pic/' . uniqid() . '.jpg';

        // Save the compressed image
        Storage::disk('public')->put($filename, $image);

        // Delete old profile picture
        if ($this->mainCard) {
            // main card
            if ($user->profile_pic && file_exists(storage_path('app/public/' . $user->profile_pic))) {
                unlink(storage_path('app/public/' . $user->profile_pic));
            }

            $updated = $user->update([
                'profile_pic' => $filename
            ]);
        } else {
            // subcard
            $checkSubCardPic = SubCard::where('active_card', true)
                ->where('user_id', $user->id)
                ->pluck('profile_pic')
                ->first();

            if ($checkSubCardPic && file_exists(storage_path('app/public/' . $checkSubCardPic))) {
                unlink(storage_path('app/public/' . $checkSubCardPic));
            }

            $updated = $user->subcards()
                ->where('active_card', true)
                ->update([
                    'profile_pic' => $filename
                ]);
        }

        if ($updated) {
            session()->flash('success', 'Profile picture successfully updated.');
        } else {
            session()->flash('error', 'Error in updating profile picture.');
        }

        return $this->redirect('/dashboard', navigate: true);
    }


    // After uploading the image, manually validate. if image is valid, display on the modal
    public function updatedImage()
    {

        try {
            $this->validate([
                'image' => 'mimes:jpeg,png,jpg,webp,heif,heic|max:5120',
            ]);

            $this->temporaryUrl = $this->image->temporaryUrl();
        } catch (\Illuminate\Validation\ValidationException $e) {

            session()->flash('error', 'The file must be an image (jpeg, png, jpg, heic, heif or webp).');
            return $this->redirect('/dashboard', navigate: true);
        }
    }

    public function mount()
    {
        $this->checkMain = User::where('id', auth()->user()->id)->count();
        $this->checkSub = SubCard::where('user_id', auth()->user()->id)->where('active_card', true)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->first();
            $this->mainCard = false;
        }
    }

    public function render()
    {
        return view('livewire.upload-image-modal');
    }
}
