<?php

namespace App\Livewire;

use Illuminate\Database\Eloquent\Model;
use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use Spatie\Image\Image;

class UploadPhysicalCardBackModal extends Component
{
    use WithFileUploads;

    public Model $model;

    public $temporaryUrl;
    public ?string $croppedBlob;
    public $physical_card;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]
    public $image;

    public function handleCroppedImage($croppedBlob, $cropRegions, $imageSize)
    {
        Image::load($this->image->getRealPath())->width($imageSize['naturalWidth'])->height($imageSize['naturalHeight'])
            ->save();

        Image::load($this->image->getRealPath())
            ->manualCrop($cropRegions['width'], $cropRegions['height'], $cropRegions['x'], $cropRegions['y'])
            ->save();

        $this->croppedBlob = $croppedBlob;

        $this->dispatch('physicalCardBack', $this->image->getRealPath());

        $this->dispatch('setPhysicalCardBack', $this->croppedBlob);
    }

    // After uploading the image, manually validate. if image is valid, display on the modal
    public function updatedImage()
    {
        try {
            $this->validate([
                'image' => 'image|mimes:jpeg,png,jpg,webp,heif|max:5120',
            ]);

            $this->temporaryUrl = $this->image->temporaryUrl();
        } catch (\Illuminate\Validation\ValidationException $e) {
            // Handle validation failure
            session()->flash('error', 'The file must be an image (jpeg, png, jpg, heif or webp).');
            return $this->redirect('/dashboard', navigate: true);
        }
    }

    public function render()
    {
        return view('livewire.upload-physical-card-back-modal');
    }
}
