<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Attributes\Validate;
use Livewire\Attributes\On;
use Illuminate\Database\Eloquent\Model;

class VideoThumbnailField extends Component
{
    use WithFileUploads;

    public Model $model;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]
    public $image;

    public ?string $croppedBlob;

    public $video_thumbnail;

    #[On('setVideoThumbnail')]
    public function setVideoThumbnail($croppedBlob)
    {
        $this->croppedBlob = $croppedBlob;
    }

    // #[On('setEditEventImage')]
    // public function setEventImageEdit($video_thumbnail)
    // {
    //     $this->video_thumbnail = $video_thumbnail;
    // }

    #[On('setEditVideoThumbnail')]
    public function setEditVideoThumbnail($video_thumbnail)
    {
        $this->video_thumbnail = $video_thumbnail;
    }

    public function render()
    {
        return view('livewire.video-thumbnail-field');
    }
}
