<?php

namespace App\Livewire;

use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use App\Models\SubCard;
use App\Models\User;
use App\Models\UserSettings;

class WelcomePage extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $app_name;

    public $site_slogan;
    public $site_desc, $site_slogan_color_1, $site_slogan_color_2, $site_button_color, $site_button_text_color, $site_link_color;
    public $thumbnail;
    public $logo;
    public $mockup;

    public $keyword = '';
    public $username;
    public $page_id; //subcard id, used in query

    //search results
    public $users = [];

    public function updatedKeyword()
    {
        $this->searchUsers();
    }

    public function searchUsers()
    {
        $query = $this->keyword;

        if ($query) {
            $isUsernameOnlySearch = str_starts_with($query, '@');
            $query = ltrim($query, '@'); // remove @ if present

            // USER QUERY
            $users = User::leftJoin('user_settings', 'users.id', '=', 'user_settings.user_id')
                ->where('users.is_admin', false)
                ->where(function ($queryBuilder) use ($query, $isUsernameOnlySearch) {
                    if ($isUsernameOnlySearch) {
                        $queryBuilder->where('users.username', 'like', "%$query%");
                    } else {
                        $queryBuilder->where('users.username', 'like', "%$query%")
                            ->orWhere('users.email', 'like', "%$query%")
                            ->orWhere('users.firstname', 'like', "%$query%")
                            ->orWhere('users.lastname', 'like', "%$query%")
                            ->orWhere('users.job_title', 'like', "%$query%")
                            ->orWhere('users.company', 'like', "%$query%")
                            ->orWhereRaw("CONCAT(users.firstname, ' ', users.lastname) LIKE ?", ["%$query%"])
                            ->orWhereRaw("CONCAT(users.lastname, ' ', users.firstname) LIKE ?", ["%$query%"]);
                    }
                })
                ->where(function ($queryBuilder) {
                    $queryBuilder->where(function ($subQuery) {
                        $subQuery->where('user_settings.setting_key', 'searchable')
                            ->where('user_settings.setting_value', true)
                            ->whereNull('user_settings.page_id');
                    })
                        ->where('users.is_active', true)
                        ->orWhereNull('user_settings.id'); // Include users without settings
                })
                ->limit(10)
                ->get()
                ->map(function ($user) {
                    return (object)[
                        'username' => $user->username,
                        'firstname' => $user->firstname,
                        'lastname' => $user->lastname,
                        'job_title' => $user->job_title,
                        'profile_pic' => $user->profile_pic,
                        'company' => $user->company,
                        'user_type' => $user->user_type,
                    ];
                });

            // SUBCARD QUERY
            // $subcards = SubCard::leftJoin('user_settings', 'subcards.id', '=', 'user_settings.page_id')
            $subcards = SubCard::leftJoin('users', 'subcards.user_id', '=', 'users.id')
                ->leftJoin('user_settings', 'subcards.id', '=', 'user_settings.page_id')
                ->select('subcards.*', 'users.user_type')
                ->where(function ($queryBuilder) use ($query, $isUsernameOnlySearch) {
                    if ($isUsernameOnlySearch) {
                        $queryBuilder->where('subcards.username', 'like', "%$query%");
                    } else {
                        $queryBuilder->where('subcards.username', 'like', "%$query%")
                            ->orWhere('subcards.email', 'like', "%$query%")
                            ->orWhere('subcards.firstname', 'like', "%$query%")
                            ->orWhere('subcards.lastname', 'like', "%$query%")
                            ->orWhere('subcards.job_title', 'like', "%$query%")
                            ->orWhere('subcards.company', 'like', "%$query%")
                            ->orWhereRaw("CONCAT(subcards.firstname, ' ', subcards.lastname) LIKE ?", ["%$query%"])
                            ->orWhereRaw("CONCAT(subcards.lastname, ' ', subcards.firstname) LIKE ?", ["%$query%"]);
                    }
                })
                ->where(function ($queryBuilder) {
                    $queryBuilder->where(function ($subQuery) {
                        $subQuery->where('user_settings.setting_key', 'searchable')
                            ->where('user_settings.setting_value', true);
                    })
                        ->where('subcards.is_active', true)
                        ->orWhere('user_settings.id'); // Include users without settings
                })
                ->limit(10)
                ->get()
                ->map(function ($user) {
                    return (object)[
                        'username' => $user->username,
                        'firstname' => $user->firstname,
                        'lastname' => $user->lastname,
                        'job_title' => $user->job_title,
                        'profile_pic' => $user->profile_pic,
                        'company' => $user->company,
                        'user_type' => $user->user_type,
                    ];
                });

            // Merge, deduplicate, and sort
            $merged = array_merge($users->toArray(), $subcards->toArray());
            $merged = collect($merged)->unique('username')->values()->all();

            usort($merged, function ($a, $b) {
                return strcmp($a->firstname, $b->firstname);
            });

            $this->users = collect($merged);
        } else {
            $this->users = [];
        }
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->app_name = $default->app_name;
        $this->site_slogan = $default->site_slogan;
        $this->site_desc = $default->site_desc;
        $this->site_slogan_color_1 = $default->site_slogan_color_1;
        $this->site_slogan_color_2 = $default->site_slogan_color_2;
        $this->site_button_color = $default->site_button_color;
        $this->site_link_color = $default->site_link_color;
        $this->site_button_text_color = $default->site_button_text_color;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->logo = $default->logo;

        $this->mockup = $default->mockup;

        // dd($this->site_slogan_color_1, $this->site_slogan_color_2);

        return view('livewire.welcome-page', [
            'users' => $this->users,
        ])
            ->title($this->site_name)
            ->layoutData([
                'thumbnail' => $this->thumbnail,
                'mockup' => $this->mockup,
                'logo' => $this->logo,
                'site_slogan' => $this->site_slogan,
                'site_desc' => $this->site_desc,
                'site_slogan_color_1' => $this->site_slogan_color_1,
                'site_slogan_color_2' => $this->site_slogan_color_2,
                'site_button_color' => $this->site_button_color,
                'site_button_text_color' => $this->site_button_text_color,
                'site_link_color' => $this->site_link_color,
                'app_name' => $this->app_name,
            ]);
    }
}
