<?php

namespace App\Models;

use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\SubCard;
use App\Helpers\SavingLinkHelpers;

class Button extends Model implements Sortable
{
    use SortableTrait;

    protected $fillable = [
        'form_id',
        'title',
        'description',
        'link',
        'type',
        'view',
        'user_id',
        'order',
        'page_id',
        'is_active',
        'thumbnail'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function subcard()
    {
        return $this->belongsTo(SubCard::class, 'page_id');
    }

    public function members()
    {
        return $this->hasMany(Member::class, 'team_id');
    }

    protected static function booted()
    {
        //dont delete, important
        // static::creating(function ($button) {
        //     static::handleLinkFormatting($button);
        // });

        //dont delete, important
        // static::updating(function ($button) {
        //     static::handleLinkFormatting($button);
        // });

        static::saving(function ($button) {
            static::handleLinkFormatting($button);
        });

        static::deleting(function ($button) {

            // Delete Sales Page Thumbnail
            if ($button->type == 'team') {
                // Member::where('team_id', $button->id)->delete();
                $button->members()->delete();
            }
        });
    }

    protected static function handleLinkFormatting($button)
    {
        // Validate the links before saving
        if ($button['type'] == 'cashapp') {
            try {
                $cashAppLink = SavingLinkHelpers::saveCashApp($button['link']);
                $button['link'] = $cashAppLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid $cashtag/link.');
                // return redirect()->back();
            }
        } else if ($button['type'] == 'email') {
            try {
                $paypalemailLink = SavingLinkHelpers::savePaypalEmail($button['link']);
                $button['link'] = $paypalemailLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid email.');
            }
        } else if ($button['type'] == 'phone' || $button['type'] == 'sms') {
            try {
                $contactNumber = SavingLinkHelpers::saveContactNumber($button['link']);
                $button['link'] = $contactNumber;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid number.');
                // return redirect()->back();
            }
        } else if ($button['type'] == 'zelle') {
            try {
                $zelleLink = SavingLinkHelpers::saveZelle($button['link']);
                $button['link'] = $zelleLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid number/email.');
                // return redirect()->back();
            }
        } else if ($button['type'] == 'paypal_email') {
            try {
                $paypalemailLink = SavingLinkHelpers::savePaypalEmail($button['link']);
                $button['link'] = $paypalemailLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid email.');
                // return redirect()->back();
            }
        } else if ($button['type'] == 'paypal_link') {
            try {
                $paypalLink = SavingLinkHelpers::savePaypalLink($button['link']);
                $button['link'] = $paypalLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid paypal username/link.');
                // return redirect()->back();
            }
        } else if ($button['type'] == 'apple_pay') {
            try {
                $applepayLink = SavingLinkHelpers::saveApplePay($button['link']);
                $button['link'] = $applepayLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid number.');
                // return redirect()->back();
            }
        } else if ($button['type'] == 'venmo') {
            try {
                $venmoLink = SavingLinkHelpers::saveVenmo($button['link']);
                $button['link'] = $venmoLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid venmo username/link.');
                // return redirect()->back();
            }
        } else if ($button['type'] == 'whatsapp') {
            try {
                $whatsappLink = SavingLinkHelpers::saveWhatsApp($button['link']);
                $button['link'] = $whatsappLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid whatsapp link/number.');
            }
        } else if ($button['type'] == 'wechat') {
            try {
                $wechatLink = SavingLinkHelpers::saveWeChat($button['link']);
                $button['link'] = $wechatLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid wechat id/link.');
            }
        } else if ($button['type'] == 'zalo') {
            try {
                $zaloLink = SavingLinkHelpers::saveZalo($button['link']);
                $button['link'] = $zaloLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid Zalo number or link.');
            }
        } else if ($button['type'] == 'telegram') {
            try {
                $telegramLink = SavingLinkHelpers::saveTelegram($button['link']);
                $button['link'] = $telegramLink;
            } catch (\InvalidArgumentException $e) {
                throw new \InvalidArgumentException('Invalid input. Please enter a valid telegram link/username/number.');
                // return redirect()->back();
            }
        } else {
            // if type = link
            if (!in_array($button['type'], ['vcf', 'help', 'exchange', 'bio', 'shop', 'services', 'feedback', 'events', 'sales', 'team', 'driving', 'zoom_replay', 'reviews', 'trusted_network', 'payment_other', 'chime', 'square', 'payments', 'form'])) {
                try {
                    $securedLink = SavingLinkHelpers::saveSecureLink($button['link']);
                    $button['link'] = $securedLink;
                } catch (\InvalidArgumentException $e) {
                    throw new \InvalidArgumentException('Invalid input. Please enter a valid URL/link.');
                    // return redirect()->back();
                }
            }
        }
    }
}
