<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Helpers\SavingLinkHelpers;
use App\Observers\FeedbackFormObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;

#[ObservedBy([FeedbackFormObserver::class])]
class FeedbackForm extends Model
{
    protected $table = 'feedback_form';

    protected $fillable = [
        'user_id',
        'page_id',
        'firstname',
        'lastname',
        'email',
        'phone',
        'profile_pic',
        'feedback',
    ];

    protected $casts = [
        'page_id' => 'integer',
        'user_id' => 'integer',
    ];

    protected static function booted()
    {
        static::saving(function ($user) {
            if ($user->phone) {
                try {
                    $contactNumber = SavingLinkHelpers::saveContactNumber($user['phone']);
                    $user['phone'] = $contactNumber;
                } catch (\InvalidArgumentException $e) {
                    throw new \InvalidArgumentException('Invalid input. Please enter a valid number.');
                }
            }
        });

        static::deleting(function ($user) {
            if ($user->profile_pic) {
                $path = 'app/public/' . $user->profile_pic;
                if (file_exists(storage_path($path))) {
                    unlink(storage_path($path));
                }
            }
        });
    }
}
