<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use App\Models\User;
use App\Models\SubCard;
use App\Models\Button;
use App\Models\FormSubmission;

class LeadCaptureForm extends Model
{
    protected $table = 'lead_capture_form';
    protected $fillable = [
        'user_id',
        'page_id',
        'title',
        'description',
        'slug',
        'image',
        'active_image',
        'video',
        'active_video',
        'sender_email',
        'email_received',
        'link_attached',
        'is_active',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function subcard()
    {
        return $this->belongsTo(SubCard::class, 'page_id');
    }

    protected static function booted()
    {
        static::creating(function ($form) {

            if (empty($form->slug)) {
                $baseSlug = Str::slug($form->title);
                $slug = $baseSlug;
                $count = 1;

                // Make slug unique PER USER
                if ($form->page_id) {
                    while (static::where('page_id', $form->page_id)
                        ->where('slug', $slug)
                        ->exists()
                    ) {
                        $slug = $baseSlug . '-' . $count++;
                    }
                } else {
                    while (static::where('user_id', $form->user_id)
                        ->where('slug', $slug)
                        ->exists()
                    ) {
                        $slug = $baseSlug . '-' . $count++;
                    }
                }

                $form->slug = $slug;
            }
        });

        static::created(function ($form) {
            // if ($form->user_id) {
            //     $username = User::where('id', $form->user_id)->value('username');
            //     Button::create([
            //         'user_id'   => $form->user_id,
            //         'form_id'   => $form->id,
            //         'title'     => $form->title,
            //         'link'      => route('form.show', [$username, $form->slug]),
            //         'type'      => 'form',
            //         'view'      => 'links',
            //         'page_id'   => NULL,
            //         'is_active' => true,
            //     ]);
            // }

            if ($form->page_id) {
                $username = SubCard::where('id', $form->page_id)->value('username');
                $user_id = SubCard::where('id', $form->page_id)->value('user_id');
                Button::create([
                    'user_id'   => $user_id,
                    'form_id'   => $form->id,
                    'title'     => $form->title,
                    'link'      => route('form.show', [$username, $form->slug]),
                    'type'      => 'form',
                    'view'      => 'links',
                    'page_id'   => $form->page_id,
                    'is_active' => true,
                ]);
            } else {
                $username = User::where('id', $form->user_id)->value('username');
                Button::create([
                    'user_id'   => $form->user_id,
                    'form_id'   => $form->id,
                    'title'     => $form->title,
                    'link'      => route('form.show', [$username, $form->slug]),
                    'type'      => 'form',
                    'view'      => 'links',
                    'page_id'   => NULL,
                    'is_active' => true,
                ]);
            }
        });

        static::updating(function ($form) {
            if ($form->isDirty('image') && $form->getOriginal('image')) {
                $path = 'app/public/' . $form->getOriginal('image');
                @unlink(storage_path($path));
            }

            if ($form->isDirty('title')) {

                $baseSlug = Str::slug($form->title);
                $slug = $baseSlug;
                $count = 1;

                // Unique PER USER (exclude itself)
                if ($form->page_id) {
                    while (static::where('page_id', $form->page_id)
                        ->where('slug', $slug)
                        ->exists()
                    ) {
                        $slug = $baseSlug . '-' . $count++;
                    }
                } else {
                    while (static::where('user_id', $form->user_id)
                        ->where('slug', $slug)
                        ->exists()
                    ) {
                        $slug = $baseSlug . '-' . $count++;
                    }
                }

                $form->slug = $slug;

                // Update related Button
                $username = $form->user_id
                    ? User::where('id', $form->user_id)->value('username')
                    : SubCard::where('id', $form->page_id)->value('username');

                Button::where('form_id', $form->id)
                    ->where('type', 'form')
                    ->update([
                        'title' => $form->title,
                        'link'  => route('form.show', [$username, $form->slug]),
                    ]);
            }
        });

        static::deleting(function ($form) {
            if ($form->image) {
                $path = 'app/public/' . $form->image;
                if ($form->image) {
                    @unlink(storage_path($path));
                }
            }

            // if form is being deleted, also delete related button
            Button::where('form_id', $form->id)
                ->where('type', 'form')
                ->delete();

            FormSubmission::where('form_id', $form->id)->delete();
        });
    }
}
